/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.imap.storage.file.wal.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.seatunnel.engine.imap.storage.api.exception.IMapStorageException;
import org.apache.seatunnel.engine.imap.storage.file.bean.IMapFileData;
import org.apache.seatunnel.engine.imap.storage.file.common.WALDataUtils;
import org.apache.seatunnel.engine.imap.storage.file.wal.reader.IFileReader;
import org.apache.seatunnel.engine.serializer.api.Serializer;

public class DefaultReader
implements IFileReader<IMapFileData> {
    private static final int DEFAULT_QUERY_LIST_SIZE = 1024;
    FileSystem fs;
    Serializer serializer;

    @Override
    public String identifier() {
        return "default";
    }

    @Override
    public void initialize(FileSystem fs, Serializer serializer) throws IOException {
        this.fs = fs;
        this.serializer = serializer;
    }

    @Override
    public List<IMapFileData> readAllData(Path parentPath) throws IOException {
        List<String> fileNames = this.getFileNames(parentPath);
        if (CollectionUtils.isEmpty(fileNames)) {
            return new ArrayList<IMapFileData>();
        }
        ArrayList<IMapFileData> result = new ArrayList<IMapFileData>(1024);
        for (String fileName : fileNames) {
            result.addAll(this.readData(new Path(parentPath, fileName)));
        }
        return result;
    }

    private List<String> getFileNames(Path parentPath) {
        try {
            if (!this.fs.exists(parentPath)) {
                return new ArrayList<String>();
            }
            RemoteIterator fileStatusRemoteIterator = this.fs.listFiles(parentPath, true);
            ArrayList<String> fileNames = new ArrayList<String>();
            while (fileStatusRemoteIterator.hasNext()) {
                LocatedFileStatus fileStatus = (LocatedFileStatus)fileStatusRemoteIterator.next();
                if (!fileStatus.getPath().getName().endsWith("wal.txt")) continue;
                fileNames.add(fileStatus.getPath().toString());
            }
            return fileNames;
        }
        catch (IOException e) {
            throw new IMapStorageException((Throwable)e, "get file names error,path is s%", new Object[]{parentPath});
        }
    }

    private List<IMapFileData> readData(Path path) throws IOException {
        ArrayList<IMapFileData> result = new ArrayList<IMapFileData>(1024);
        long length = this.fs.getFileStatus(path).getLen();
        try (FSDataInputStream in = this.fs.open(path);){
            byte[] datas = new byte[(int)length];
            in.readFully(datas);
            int startIndex = 0;
            while (startIndex + 12 < datas.length) {
                byte[] metadata = new byte[12];
                System.arraycopy(datas, startIndex, metadata, 0, 12);
                int dataLength = WALDataUtils.byteArrayToInt(metadata);
                if ((startIndex += 12) + dataLength > datas.length) {
                    break;
                }
                byte[] data = new byte[dataLength];
                System.arraycopy(datas, startIndex, data, 0, data.length);
                IMapFileData fileData = (IMapFileData)this.serializer.deserialize(data, IMapFileData.class);
                result.add(fileData);
                startIndex += data.length;
            }
        }
        return result;
    }
}

