/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.imap.storage.file.common;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.seatunnel.engine.imap.storage.api.exception.IMapStorageException;
import org.apache.seatunnel.engine.imap.storage.file.bean.IMapFileData;
import org.apache.seatunnel.engine.imap.storage.file.config.FileConfiguration;
import org.apache.seatunnel.engine.imap.storage.file.wal.DiscoveryWalFileFactory;
import org.apache.seatunnel.engine.imap.storage.file.wal.reader.IFileReader;
import org.apache.seatunnel.engine.serializer.api.Serializer;

public class WALReader {
    private final Serializer serializer;
    private final IFileReader fileReader;

    public WALReader(FileSystem fs, FileConfiguration configuration, Serializer serializer) throws IOException {
        this.serializer = serializer;
        this.fileReader = DiscoveryWalFileFactory.getReader(configuration.getName());
        this.fileReader.initialize(fs, serializer);
    }

    private List<IMapFileData> readAllData(Path parentPath) throws IOException {
        return this.fileReader.readAllData(parentPath);
    }

    public Set<Object> loadAllKeys(Path parentPath) throws IOException {
        List<IMapFileData> allData = this.readAllData(parentPath);
        if (CollectionUtils.isEmpty(allData)) {
            return new HashSet<Object>();
        }
        Collections.sort(allData);
        HashSet<Object> result = new HashSet<Object>(allData.size());
        HashMap<Object, Long> deleteMap = new HashMap<Object, Long>();
        for (IMapFileData data : allData) {
            Object key = this.deserializeData(data.getKey(), data.getKeyClassName());
            if (deleteMap.containsKey(key)) continue;
            if (data.isDeleted()) {
                deleteMap.put(key, data.getTimestamp());
                continue;
            }
            if (result.contains(key)) continue;
            result.add(key);
        }
        return result;
    }

    public Map<Object, Object> loadAllData(Path parentPath, Set<Object> searchKeys) throws IOException {
        List<IMapFileData> allData = this.readAllData(parentPath);
        if (CollectionUtils.isEmpty(allData)) {
            return new HashMap<Object, Object>();
        }
        Collections.sort(allData);
        HashMap<Object, Object> result = new HashMap<Object, Object>(allData.size());
        HashMap<Object, Long> deleteMap = new HashMap<Object, Long>();
        boolean searchByKeys = CollectionUtils.isNotEmpty(searchKeys);
        for (IMapFileData data : allData) {
            Object key = this.deserializeData(data.getKey(), data.getKeyClassName());
            if (searchByKeys && !searchKeys.contains(data.getKey()) || deleteMap.containsKey(key)) continue;
            if (data.isDeleted()) {
                deleteMap.put(key, data.getTimestamp());
                continue;
            }
            if (result.containsKey(key)) continue;
            Object value = this.deserializeData(data.getValue(), data.getValueClassName());
            result.put(key, value);
        }
        return result;
    }

    private Object deserializeData(byte[] data, String className) {
        try {
            Class clazz = ClassUtils.getClass((String)className);
            try {
                return this.serializer.deserialize(data, clazz);
            }
            catch (IOException e) {
                throw new IMapStorageException((Throwable)e, "deserialize data error: data is s%, className is s%", new Object[]{data, className});
            }
        }
        catch (ClassNotFoundException e) {
            throw new IMapStorageException((Throwable)e, "deserialize data error, class name is {}", new Object[]{className});
        }
    }
}

