/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.configuration.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.Condition;
import org.apache.seatunnel.api.configuration.util.Expression;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.OptionUtil;
import org.apache.seatunnel.api.configuration.util.OptionValidationException;
import org.apache.seatunnel.api.configuration.util.RequiredOption;

public class ConfigValidator {
    private final ReadonlyConfig config;

    private ConfigValidator(ReadonlyConfig config) {
        this.config = config;
    }

    public static ConfigValidator of(ReadonlyConfig config) {
        return new ConfigValidator(config);
    }

    public void validate(OptionRule rule) {
        List<RequiredOption> requiredOptions = rule.getRequiredOptions();
        for (RequiredOption requiredOption : requiredOptions) {
            this.validate(requiredOption);
        }
    }

    void validate(RequiredOption requiredOption) {
        if (requiredOption instanceof RequiredOption.AbsolutelyRequiredOptions) {
            this.validate((RequiredOption.AbsolutelyRequiredOptions)requiredOption);
            return;
        }
        if (requiredOption instanceof RequiredOption.BundledRequiredOptions) {
            this.validate((RequiredOption.BundledRequiredOptions)requiredOption);
            return;
        }
        if (requiredOption instanceof RequiredOption.ExclusiveRequiredOptions) {
            this.validate((RequiredOption.ExclusiveRequiredOptions)requiredOption);
            return;
        }
        if (requiredOption instanceof RequiredOption.ConditionalRequiredOptions) {
            this.validate((RequiredOption.ConditionalRequiredOptions)requiredOption);
            return;
        }
        throw new UnsupportedOperationException(String.format("This type option(%s) of validation is not supported", requiredOption.getClass()));
    }

    private List<Option<?>> getAbsentOptions(List<Option<?>> requiredOption) {
        ArrayList absent = new ArrayList();
        for (Option<?> option : requiredOption) {
            if (this.hasOption(option)) continue;
            absent.add(option);
        }
        return absent;
    }

    void validate(RequiredOption.AbsolutelyRequiredOptions requiredOption) {
        List<Option<?>> absentOptions = this.getAbsentOptions(requiredOption.getRequiredOption());
        if (absentOptions.size() == 0) {
            return;
        }
        throw new OptionValidationException("There are unconfigured options, the options(%s) are required.", OptionUtil.getOptionKeys(absentOptions));
    }

    boolean hasOption(Option<?> option) {
        return this.config.getOptional(option).isPresent();
    }

    boolean validate(RequiredOption.BundledRequiredOptions bundledRequiredOptions) {
        List<Option<?>> bundledOptions = bundledRequiredOptions.getRequiredOption();
        ArrayList present = new ArrayList();
        ArrayList absent = new ArrayList();
        for (Option<?> option : bundledOptions) {
            if (this.hasOption(option)) {
                present.add(option);
                continue;
            }
            absent.add(option);
        }
        if (present.size() == bundledOptions.size()) {
            return true;
        }
        if (absent.size() == bundledOptions.size()) {
            return false;
        }
        throw new OptionValidationException("These options(%s) are bundled, must be present or absent together. The options present are: %s. The options absent are %s.", OptionUtil.getOptionKeys(bundledOptions), OptionUtil.getOptionKeys(present), OptionUtil.getOptionKeys(absent));
    }

    void validate(RequiredOption.ExclusiveRequiredOptions exclusiveRequiredOptions) {
        ArrayList presentOptions = new ArrayList();
        for (Option<?> option : exclusiveRequiredOptions.getExclusiveOptions()) {
            if (!this.hasOption(option)) continue;
            presentOptions.add(option);
        }
        int count = presentOptions.size();
        if (count == 1) {
            return;
        }
        if (count == 0) {
            throw new OptionValidationException("There are unconfigured options, these options(%s) are mutually exclusive, allowing only one set(\"[] for a set\") of options to be configured.", OptionUtil.getOptionKeys(exclusiveRequiredOptions.getExclusiveOptions()));
        }
        if (count > 1) {
            throw new OptionValidationException("These options(%s) are mutually exclusive, allowing only one set(\"[] for a set\") of options to be configured.", OptionUtil.getOptionKeys(presentOptions));
        }
    }

    void validate(RequiredOption.ConditionalRequiredOptions conditionalRequiredOptions) {
        Expression expression = conditionalRequiredOptions.getExpression();
        boolean match = this.validate(expression);
        if (!match) {
            return;
        }
        List<Option<?>> absentOptions = this.getAbsentOptions(conditionalRequiredOptions.getRequiredOption());
        if (absentOptions.size() == 0) {
            return;
        }
        throw new OptionValidationException("There are unconfigured options, the options(%s) are required because [%s] is true.", OptionUtil.getOptionKeys(absentOptions), expression.toString());
    }

    private boolean validate(Expression expression) {
        Condition<?> condition = expression.getCondition();
        boolean match = this.validate(condition);
        if (!expression.hasNext()) {
            return match;
        }
        if (expression.and().booleanValue()) {
            return match && this.validate(expression.getNext());
        }
        return match || this.validate(expression.getNext());
    }

    private <T> boolean validate(Condition<T> condition) {
        Option<T> option = condition.getOption();
        boolean match = Objects.equals(condition.getExpectValue(), this.config.get(option));
        if (!condition.hasNext()) {
            return match;
        }
        if (condition.and().booleanValue()) {
            return match && this.validate(condition.getNext());
        }
        return match || this.validate(condition.getNext());
    }
}

