/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.source;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.seatunnel.api.source.SourceEvent;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.state.CheckpointListener;

public interface SourceSplitEnumerator<SplitT extends SourceSplit, StateT>
extends AutoCloseable,
CheckpointListener {
    public void open();

    public void run() throws Exception;

    @Override
    public void close() throws IOException;

    public void addSplitsBack(List<SplitT> var1, int var2);

    public int currentUnassignedSplitSize();

    public void handleSplitRequest(int var1);

    public void registerReader(int var1);

    public StateT snapshotState(long var1) throws Exception;

    default public void handleSourceEvent(int subtaskId, SourceEvent sourceEvent) {
    }

    public static interface Context<SplitT extends SourceSplit> {
        public int currentParallelism();

        public Set<Integer> registeredReaders();

        public void assignSplit(int var1, List<SplitT> var2);

        default public void assignSplit(int subtaskId, SplitT split) {
            this.assignSplit(subtaskId, (SplitT)Collections.singletonList(split));
        }

        public void signalNoMoreSplits(int var1);

        public void sendEventToSourceReader(int var1, SourceEvent var2);
    }
}

