/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.seatunnel.api.table.type.CompositeType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SqlType;

public class MapType<K, V>
implements CompositeType<Map<K, V>> {
    private static final List<SqlType> SUPPORTED_KEY_TYPES = Arrays.asList(SqlType.NULL, SqlType.BOOLEAN, SqlType.TINYINT, SqlType.SMALLINT, SqlType.INT, SqlType.BIGINT, SqlType.DATE, SqlType.TIME, SqlType.TIMESTAMP, SqlType.FLOAT, SqlType.DOUBLE, SqlType.STRING, SqlType.DECIMAL);
    private final SeaTunnelDataType<K> keyType;
    private final SeaTunnelDataType<V> valueType;

    public MapType(SeaTunnelDataType<K> keyType, SeaTunnelDataType<V> valueType) {
        Preconditions.checkNotNull(keyType, (Object)"The key type is required.");
        Preconditions.checkNotNull(valueType, (Object)"The value type is required.");
        Preconditions.checkArgument((boolean)SUPPORTED_KEY_TYPES.contains((Object)keyType.getSqlType()), (String)"Unsupported key types: %s", (Object[])new Object[]{keyType});
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public SeaTunnelDataType<K> getKeyType() {
        return this.keyType;
    }

    public SeaTunnelDataType<V> getValueType() {
        return this.valueType;
    }

    @Override
    public Class<Map<K, V>> getTypeClass() {
        return Map.class;
    }

    @Override
    public SqlType getSqlType() {
        return SqlType.MAP;
    }

    @Override
    public List<SeaTunnelDataType<?>> getChildren() {
        return Lists.newArrayList((Object[])new SeaTunnelDataType[]{this.keyType, this.valueType});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MapType)) {
            return false;
        }
        MapType that = (MapType)obj;
        return Objects.equals(this.keyType, that.keyType) && Objects.equals(this.valueType, that.valueType);
    }

    public int hashCode() {
        return Objects.hash(this.keyType, this.valueType);
    }

    public String toString() {
        return String.format("Map<%s, %s>", this.keyType, this.valueType);
    }
}

