/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.configuration;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.SingleChoiceOption;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class Options {
    public static OptionBuilder key(String key) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)key), (Object)"Option's key not be null.");
        return new OptionBuilder(key);
    }

    public static final class OptionBuilder {
        private final String key;

        OptionBuilder(String key) {
            this.key = key;
        }

        public TypedOptionBuilder<Boolean> booleanType() {
            return new TypedOptionBuilder<Boolean>(this.key, new TypeReference<Boolean>(){});
        }

        public TypedOptionBuilder<Integer> intType() {
            return new TypedOptionBuilder<Integer>(this.key, new TypeReference<Integer>(){});
        }

        public TypedOptionBuilder<Long> longType() {
            return new TypedOptionBuilder<Long>(this.key, new TypeReference<Long>(){});
        }

        public TypedOptionBuilder<BigDecimal> bigDecimalType() {
            return new TypedOptionBuilder<BigDecimal>(this.key, new TypeReference<BigDecimal>(){});
        }

        public TypedOptionBuilder<Float> floatType() {
            return new TypedOptionBuilder<Float>(this.key, new TypeReference<Float>(){});
        }

        public TypedOptionBuilder<Double> doubleType() {
            return new TypedOptionBuilder<Double>(this.key, new TypeReference<Double>(){});
        }

        public TypedOptionBuilder<String> stringType() {
            return new TypedOptionBuilder<String>(this.key, new TypeReference<String>(){});
        }

        public TypedOptionBuilder<Duration> durationType() {
            return new TypedOptionBuilder<Duration>(this.key, new TypeReference<Duration>(){});
        }

        public <T extends Enum<T>> TypedOptionBuilder<T> enumType(final Class<T> enumClass) {
            return new TypedOptionBuilder(this.key, new TypeReference<T>(){

                public Type getType() {
                    return enumClass;
                }
            });
        }

        public TypedOptionBuilder<Map<String, String>> mapType() {
            return new TypedOptionBuilder<Map<String, String>>(this.key, new TypeReference<Map<String, String>>(){});
        }

        public TypedOptionBuilder<List<String>> listType() {
            return new TypedOptionBuilder<List<String>>(this.key, new TypeReference<List<String>>(){});
        }

        public <T> TypedOptionBuilder<List<T>> listType(final Class<T> subClass) {
            return new TypedOptionBuilder<List<T>>(this.key, new TypeReference<List<T>>(){

                public Type getType() {
                    return new ParameterizedType(){

                        @Override
                        public Type[] getActualTypeArguments() {
                            return new Type[]{subClass};
                        }

                        @Override
                        public Type getRawType() {
                            return List.class;
                        }

                        @Override
                        public Type getOwnerType() {
                            return null;
                        }
                    };
                }
            });
        }

        public <T> TypedOptionBuilder<T> objectType(final Class<T> option) {
            return new TypedOptionBuilder(this.key, new TypeReference<T>(){

                public Type getType() {
                    return option;
                }
            });
        }

        public <T> SingleChoiceOptionBuilder<T> singleChoice(final @NonNull Class<T> optionType, @NonNull List<T> optionValues) {
            if (optionType == null) {
                throw new NullPointerException("optionType is marked non-null but is null");
            }
            if (optionValues == null) {
                throw new NullPointerException("optionValues is marked non-null but is null");
            }
            return new SingleChoiceOptionBuilder<T>(this.key, new TypeReference<T>(){

                public Type getType() {
                    return optionType;
                }
            }, optionValues);
        }

        public <T> TypedOptionBuilder<T> type(TypeReference<T> typeReference) {
            return new TypedOptionBuilder<T>(this.key, typeReference);
        }
    }

    public static class SingleChoiceOptionBuilder<T> {
        private final List<T> optionValues;
        private final String key;
        private final TypeReference<T> typeReference;

        SingleChoiceOptionBuilder(String key, TypeReference typeReference, List<T> optionValues) {
            this.optionValues = optionValues;
            this.key = key;
            this.typeReference = typeReference;
        }

        public SingleChoiceOption<T> defaultValue(T value) {
            return new SingleChoiceOption<T>(this.key, this.typeReference, this.optionValues, value);
        }

        public SingleChoiceOption<T> noDefaultValue() {
            return new SingleChoiceOption<Object>(this.key, this.typeReference, this.optionValues, null);
        }
    }

    public static class TypedOptionBuilder<T> {
        private final String key;
        private final TypeReference<T> typeReference;

        TypedOptionBuilder(String key, TypeReference<T> typeReference) {
            this.key = key;
            this.typeReference = typeReference;
        }

        public Option<T> defaultValue(T value) {
            return new Option<T>(this.key, this.typeReference, value);
        }

        public Option<T> noDefaultValue() {
            return new Option<Object>(this.key, this.typeReference, null);
        }
    }
}

