/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.schema.handler;

import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.schema.event.AlterTableAddColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableChangeColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableColumnsEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableDropColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableModifyColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableNameEvent;
import org.apache.seatunnel.api.table.schema.event.SchemaChangeEvent;
import org.apache.seatunnel.api.table.schema.handler.AlterTableSchemaEventHandler;
import org.apache.seatunnel.api.table.schema.handler.TableSchemaChangeEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableSchemaChangeEventDispatcher
implements TableSchemaChangeEventHandler {
    private static final Logger log = LoggerFactory.getLogger(TableSchemaChangeEventDispatcher.class);
    private final Map<Class, TableSchemaChangeEventHandler> handlers = TableSchemaChangeEventDispatcher.createHandlers();
    private TableSchema schema;

    @Override
    public TableSchema get() {
        return this.schema;
    }

    @Override
    public TableSchemaChangeEventHandler reset(TableSchema schema) {
        this.schema = schema;
        return this;
    }

    @Override
    public TableSchema apply(SchemaChangeEvent event) {
        TableSchemaChangeEventHandler handler = this.handlers.get(event.getClass());
        if (handler == null) {
            log.warn("Not found handler for event: {}", event.getClass());
            return this.schema;
        }
        return handler.reset(this.schema).apply(event);
    }

    private static Map<Class, TableSchemaChangeEventHandler> createHandlers() {
        HashMap<Class, TableSchemaChangeEventHandler> handlers = new HashMap<Class, TableSchemaChangeEventHandler>();
        AlterTableSchemaEventHandler alterTableEventHandler = new AlterTableSchemaEventHandler();
        handlers.put(AlterTableEvent.class, alterTableEventHandler);
        handlers.put(AlterTableNameEvent.class, alterTableEventHandler);
        handlers.put(AlterTableColumnsEvent.class, alterTableEventHandler);
        handlers.put(AlterTableAddColumnEvent.class, alterTableEventHandler);
        handlers.put(AlterTableModifyColumnEvent.class, alterTableEventHandler);
        handlers.put(AlterTableDropColumnEvent.class, alterTableEventHandler);
        handlers.put(AlterTableChangeColumnEvent.class, alterTableEventHandler);
        return handlers;
    }
}

