/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.CommonOptions;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowAccessor;

public class MetadataUtil {
    public static final List<String> METADATA_FIELDS = new ArrayList<String>();

    public static void setDelay(SeaTunnelRow row, Long delay) {
        row.getOptions().put(CommonOptions.DELAY.getName(), delay);
    }

    public static void setPartition(SeaTunnelRow row, String[] partition) {
        row.getOptions().put(CommonOptions.PARTITION.getName(), partition);
    }

    public static void setEventTime(SeaTunnelRow row, Long delay) {
        row.getOptions().put(CommonOptions.EVENT_TIME.getName(), delay);
    }

    public static Long getDelay(SeaTunnelRowAccessor row) {
        return (Long)row.getOptions().get(CommonOptions.DELAY.getName());
    }

    public static String getDatabase(SeaTunnelRowAccessor row) {
        if (row.getTableId() == null) {
            return null;
        }
        return TablePath.of(row.getTableId()).getDatabaseName();
    }

    public static String getTable(SeaTunnelRowAccessor row) {
        if (row.getTableId() == null) {
            return null;
        }
        return TablePath.of(row.getTableId()).getTableName();
    }

    public static String getRowKind(SeaTunnelRowAccessor row) {
        return row.getRowKind().shortString();
    }

    public static String getPartitionStr(SeaTunnelRowAccessor row) {
        Object partition = row.getOptions().get(CommonOptions.PARTITION.getName());
        return Objects.nonNull(partition) ? String.join((CharSequence)",", (String[])partition) : null;
    }

    public static String[] getPartition(SeaTunnelRowAccessor row) {
        return (String[])row.getOptions().get(CommonOptions.PARTITION.getName());
    }

    public static Long getEventTime(SeaTunnelRowAccessor row) {
        return (Long)row.getOptions().get(CommonOptions.EVENT_TIME.getName());
    }

    public static boolean isMetadataField(String fieldName) {
        return METADATA_FIELDS.contains(fieldName);
    }

    static {
        Stream.of(CommonOptions.values()).filter(CommonOptions::isSupportMetadataTrans).map(CommonOptions::getName).forEach(METADATA_FIELDS::add);
    }
}

