/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.tracing;

import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.apache.seatunnel.api.tracing.MDCContext;

public class MDCCallable<V>
implements Callable<V> {
    private final Supplier<MDCContext> contextSupplier;
    private final Callable<V> delegate;

    public MDCCallable(Callable<V> delegate) {
        this(MDCContext.current(), delegate);
    }

    public MDCCallable(MDCContext context, Callable<V> delegate) {
        this(() -> context, delegate);
    }

    public MDCCallable(Supplier<MDCContext> contextSupplier, Callable<V> delegate) {
        this.contextSupplier = contextSupplier;
        this.delegate = delegate;
    }

    @Override
    public V call() throws Exception {
        try (MDCContext ignored = this.contextSupplier.get().activate();){
            V v = this.delegate.call();
            return v;
        }
    }
}

