/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.sink.multitablesink;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTableWriterRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MultiTableWriterRunnable.class);
    private final Map<String, SinkWriter<SeaTunnelRow, ?, ?>> tableIdWriterMap;
    private final BlockingQueue<SeaTunnelRow> queue;
    private volatile Throwable throwable;
    private volatile String currentTableId;

    public MultiTableWriterRunnable(Map<String, SinkWriter<SeaTunnelRow, ?, ?>> tableIdWriterMap, BlockingQueue<SeaTunnelRow> queue) {
        this.tableIdWriterMap = tableIdWriterMap;
        this.queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (true) {
            SeaTunnelRow row = null;
            try {
                row = this.queue.poll(100L, TimeUnit.MILLISECONDS);
                if (row == null) continue;
                SinkWriter<SeaTunnelRow, ?, ?> writer = this.tableIdWriterMap.get(row.getTableId());
                if (writer == null) {
                    if (this.tableIdWriterMap.size() != 1) throw new RuntimeException("MultiTableWriterRunnable can't find writer for tableId: " + row.getTableId());
                    writer = this.tableIdWriterMap.values().stream().findFirst().get();
                    this.currentTableId = (String)this.tableIdWriterMap.keySet().stream().findFirst().get();
                } else {
                    this.currentTableId = row.getTableId();
                }
                MultiTableWriterRunnable multiTableWriterRunnable = this;
                synchronized (multiTableWriterRunnable) {
                    writer.write(row);
                }
            }
            catch (InterruptedException e) {
                this.throwable = e;
                return;
            }
            catch (Throwable e) {
                log.error(String.format("MultiTableWriterRunnable error when write row %s", row), e);
                this.throwable = e;
                return;
            }
        }
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getCurrentTableId() {
        return this.currentTableId;
    }
}

