/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;

public class AbstractSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final List<Column> columns;
    protected final List<String> columnNames;

    public AbstractSchema(List<Column> columns) {
        this.columns = columns;
        this.columnNames = columns.stream().map(Column::getName).collect(Collectors.toList());
    }

    private AbstractSchema() {
        this.columns = new ArrayList<Column>();
        this.columnNames = new ArrayList<String>();
    }

    public SeaTunnelRowType toPhysicalRowDataType() {
        SeaTunnelDataType[] fieldTypes = (SeaTunnelDataType[])this.columns.stream().filter(Column::isPhysical).map(Column::getDataType).toArray(SeaTunnelDataType[]::new);
        String[] fields = (String[])this.columns.stream().filter(Column::isPhysical).map(Column::getName).toArray(String[]::new);
        return new SeaTunnelRowType(fields, fieldTypes);
    }

    public String[] getFieldNames() {
        return this.columnNames.toArray(new String[0]);
    }

    public int indexOf(String columnName) {
        return this.columnNames.indexOf(columnName);
    }

    public Column getColumn(String columnName) {
        return this.columns.get(this.indexOf(columnName));
    }

    public boolean contains(String columnName) {
        return this.columnNames.contains(columnName);
    }

    public List<Column> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractSchema)) {
            return false;
        }
        AbstractSchema other = (AbstractSchema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Column> this$columns = this.getColumns();
        List<Column> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        List<String> this$columnNames = this.getColumnNames();
        List<String> other$columnNames = other.getColumnNames();
        return !(this$columnNames == null ? other$columnNames != null : !((Object)this$columnNames).equals(other$columnNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractSchema;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Column> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        List<String> $columnNames = this.getColumnNames();
        result = result * 59 + ($columnNames == null ? 43 : ((Object)$columnNames).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractSchema(columns=" + this.getColumns() + ", columnNames=" + this.getColumnNames() + ")";
    }

    private List<String> getColumnNames() {
        return this.columnNames;
    }
}

