/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.table.catalog.AbstractSchema;
import org.apache.seatunnel.api.table.catalog.Column;

public final class MetadataSchema
extends AbstractSchema {
    private static final long serialVersionUID = 1L;

    public MetadataSchema(List<Column> columns) {
        super(columns);
    }

    public static Builder builder() {
        return new Builder();
    }

    public MetadataSchema copy() {
        List<Column> copyColumns = this.columns.stream().map(Column::copy).collect(Collectors.toList());
        return MetadataSchema.builder().columns(copyColumns).build();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetadataSchema)) {
            return false;
        }
        MetadataSchema other = (MetadataSchema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MetadataSchema;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "MetadataSchema()";
    }

    public static final class Builder {
        private final List<Column> columns = new ArrayList<Column>();

        public Builder columns(List<Column> columns) {
            this.columns.addAll(columns);
            return this;
        }

        public Builder column(Column column) {
            this.columns.add(column);
            return this;
        }

        public MetadataSchema build() {
            return new MetadataSchema(this.columns);
        }
    }
}

