/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.options.ConnectorCommonOptions;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.SeaTunnelDataTypeConvertorUtil;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.schema.TableSchemaParser;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;

public class ReadonlyConfigParser
implements TableSchemaParser<ReadonlyConfig> {
    private final TableSchemaParser.ColumnParser<ReadonlyConfig> columnParser = new ColumnParser();
    private final TableSchemaParser.FieldParser<ReadonlyConfig> fieldParser = new FieldParser();
    private final TableSchemaParser.ConstraintKeyParser<ReadonlyConfig> constraintKeyParser = new ConstraintKeyParser();
    private final TableSchemaParser.PrimaryKeyParser<ReadonlyConfig> primaryKeyParser = new PrimaryKeyParser();

    @Override
    public TableSchema parse(ReadonlyConfig readonlyConfig) {
        ReadonlyConfig schemaConfig = readonlyConfig.getOptional(ConnectorCommonOptions.SCHEMA).map(ReadonlyConfig::fromMap).orElseThrow(() -> new IllegalArgumentException("Schema config can't be null"));
        if (readonlyConfig.getOptional(ConnectorCommonOptions.FIELDS).isPresent() && schemaConfig.getOptional(ConnectorCommonOptions.COLUMNS).isPresent()) {
            throw new IllegalArgumentException("Schema config can't contains both [fields] and [columns], please correct your config first");
        }
        TableSchema.Builder tableSchemaBuilder = TableSchema.builder();
        if (readonlyConfig.getOptional(ConnectorCommonOptions.FIELDS).isPresent()) {
            tableSchemaBuilder.columns(this.fieldParser.parse(readonlyConfig));
        }
        if (schemaConfig.getOptional(ConnectorCommonOptions.COLUMNS).isPresent()) {
            tableSchemaBuilder.columns(this.columnParser.parse(schemaConfig));
        }
        if (schemaConfig.getOptional(ConnectorCommonOptions.PRIMARY_KEY).isPresent()) {
            tableSchemaBuilder.primaryKey(this.primaryKeyParser.parse(schemaConfig));
        }
        if (schemaConfig.getOptional(ConnectorCommonOptions.CONSTRAINT_KEYS).isPresent()) {
            tableSchemaBuilder.constraintKey(this.constraintKeyParser.parse(schemaConfig));
        }
        return tableSchemaBuilder.build();
    }

    private static class PrimaryKeyParser
    implements TableSchemaParser.PrimaryKeyParser<ReadonlyConfig> {
        private PrimaryKeyParser() {
        }

        @Override
        public PrimaryKey parse(ReadonlyConfig schemaConfig) {
            ReadonlyConfig primaryKeyConfig = ReadonlyConfig.fromMap((Map)schemaConfig.get(ConnectorCommonOptions.PRIMARY_KEY));
            String primaryKeyName = (String)primaryKeyConfig.getOptional(ConnectorCommonOptions.PRIMARY_KEY_NAME).orElseThrow(() -> new IllegalArgumentException("Schema config need option [primaryKey.name], please correct your config first"));
            List columns = (List)primaryKeyConfig.getOptional(ConnectorCommonOptions.PRIMARY_KEY_COLUMNS).orElseThrow(() -> new IllegalArgumentException("Schema config need option [primaryKey.columnNames], please correct your config first"));
            return new PrimaryKey(primaryKeyName, columns);
        }
    }

    private static class ConstraintKeyParser
    implements TableSchemaParser.ConstraintKeyParser<ReadonlyConfig> {
        private ConstraintKeyParser() {
        }

        @Override
        public List<ConstraintKey> parse(ReadonlyConfig schemaConfig) {
            return ((List)schemaConfig.get(ConnectorCommonOptions.CONSTRAINT_KEYS)).stream().map(ReadonlyConfig::fromMap).map(constraintKeyConfig -> {
                String constraintName = (String)constraintKeyConfig.getOptional(ConnectorCommonOptions.CONSTRAINT_KEY_NAME).orElseThrow(() -> new IllegalArgumentException("schema.constraintKeys.* config need option [constraintName], please correct your config first"));
                ConstraintKey.ConstraintType constraintType = (ConstraintKey.ConstraintType)((Object)((Object)constraintKeyConfig.getOptional(ConnectorCommonOptions.CONSTRAINT_KEY_TYPE).orElseThrow(() -> new IllegalArgumentException("schema.constraintKeys.* config need option [constraintType], please correct your config first"))));
                List columns = constraintKeyConfig.getOptional(ConnectorCommonOptions.CONSTRAINT_KEY_COLUMNS).map(constraintColumnMapList -> constraintColumnMapList.stream().map(ReadonlyConfig::fromMap).map(constraintColumnConfig -> {
                    String columnName = (String)constraintColumnConfig.getOptional(ConnectorCommonOptions.CONSTRAINT_KEY_COLUMN_NAME).orElseThrow(() -> new IllegalArgumentException("schema.constraintKeys.constraintColumns.* config need option [columnName], please correct your config first"));
                    ConstraintKey.ColumnSortType columnSortType = (ConstraintKey.ColumnSortType)((Object)((Object)((Object)((Object)constraintColumnConfig.get(ConnectorCommonOptions.CONSTRAINT_KEY_COLUMN_SORT_TYPE)))));
                    return ConstraintKey.ConstraintKeyColumn.of(columnName, columnSortType);
                }).collect(Collectors.toList())).orElseThrow(() -> new IllegalArgumentException("schema.constraintKeys.* config need option [columns], please correct your config first"));
                return ConstraintKey.of(constraintType, constraintName, columns);
            }).collect(Collectors.toList());
        }
    }

    private static class ColumnParser
    implements TableSchemaParser.ColumnParser<ReadonlyConfig> {
        private ColumnParser() {
        }

        @Override
        public List<Column> parse(ReadonlyConfig schemaConfig) {
            return ((List)schemaConfig.get(ConnectorCommonOptions.COLUMNS)).stream().map(ReadonlyConfig::fromMap).map(columnConfig -> {
                String name = (String)columnConfig.getOptional(ConnectorCommonOptions.COLUMN_NAME).orElseThrow(() -> new IllegalArgumentException("schema.columns.* config need option [name], please correct your config first"));
                SeaTunnelDataType seaTunnelDataType = columnConfig.getOptional(ConnectorCommonOptions.TYPE).map(column -> SeaTunnelDataTypeConvertorUtil.deserializeSeaTunnelDataType(name, column)).orElseThrow(() -> new IllegalArgumentException("schema.columns.* config need option [type], please correct your config first"));
                Long columnLength = (Long)columnConfig.get(ConnectorCommonOptions.COLUMN_LENGTH);
                Integer columnScale = (Integer)columnConfig.get(ConnectorCommonOptions.COLUMN_SCALE);
                Boolean nullable = (Boolean)columnConfig.get(ConnectorCommonOptions.NULLABLE);
                Object defaultValue = columnConfig.get(ConnectorCommonOptions.DEFAULT_VALUE);
                String comment = (String)columnConfig.get(ConnectorCommonOptions.COLUMN_COMMENT);
                return PhysicalColumn.of(name, seaTunnelDataType, columnLength, columnScale, nullable, defaultValue, comment);
            }).collect(Collectors.toList());
        }
    }

    private static class FieldParser
    implements TableSchemaParser.FieldParser<ReadonlyConfig> {
        private FieldParser() {
        }

        @Override
        public List<Column> parse(ReadonlyConfig schemaConfig) {
            JsonNode jsonNode = JsonUtils.toJsonNode(schemaConfig.get(ConnectorCommonOptions.FIELDS));
            Map fieldsMap = JsonUtils.toStringMap((JsonNode)jsonNode);
            int fieldsNum = fieldsMap.size();
            ArrayList<Column> columns = new ArrayList<Column>(fieldsNum);
            for (Map.Entry entry : fieldsMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                SeaTunnelDataType<?> dataType = SeaTunnelDataTypeConvertorUtil.deserializeSeaTunnelDataType(key, value);
                PhysicalColumn column = PhysicalColumn.of(key, dataType, null, null, true, null, null);
                columns.add(column);
            }
            return columns;
        }
    }
}

