/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.factory;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertor;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class DataTypeConvertorFactory {
    private final Map<String, DataTypeConvertor<?>> dataTypeConvertorMap = new HashMap();

    public DataTypeConvertorFactory() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public DataTypeConvertorFactory(ClassLoader classLoader) {
        ServiceLoader.load(DataTypeConvertor.class, classLoader).forEach(dataTypeConvertor -> this.dataTypeConvertorMap.put(dataTypeConvertor.getIdentity().toUpperCase(), (DataTypeConvertor<?>)dataTypeConvertor));
    }

    public DataTypeConvertor<?> getDataTypeConvertor(String convertorIdentify) {
        Preconditions.checkNotNull((Object)convertorIdentify, (Object)"connectorIdentify can not be null");
        if (this.dataTypeConvertorMap.containsKey(convertorIdentify.toUpperCase())) {
            return this.dataTypeConvertorMap.get(convertorIdentify.toUpperCase());
        }
        throw new IllegalArgumentException("connectorIdentify " + convertorIdentify + " is not supported");
    }
}

