/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.schema.event;

import org.apache.seatunnel.api.event.EventType;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.schema.event.AlterTableColumnEvent;

public class AlterTableChangeColumnEvent
extends AlterTableColumnEvent {
    private final Column column;
    private final boolean first;
    private final String afterColumn;
    private final String oldColumn;

    public AlterTableChangeColumnEvent(TableIdentifier tableIdentifier, String oldColumn, Column column, boolean first, String afterColumn) {
        super(tableIdentifier);
        this.oldColumn = oldColumn;
        this.column = column;
        this.first = first;
        this.afterColumn = afterColumn;
    }

    public static AlterTableChangeColumnEvent changeFirst(TableIdentifier tableIdentifier, String oldColumn, Column column) {
        return new AlterTableChangeColumnEvent(tableIdentifier, oldColumn, column, true, null);
    }

    public static AlterTableChangeColumnEvent change(TableIdentifier tableIdentifier, String oldColumn, Column column) {
        return new AlterTableChangeColumnEvent(tableIdentifier, oldColumn, column, false, null);
    }

    public static AlterTableChangeColumnEvent changeAfter(TableIdentifier tableIdentifier, String oldColumn, Column column, String afterColumn) {
        return new AlterTableChangeColumnEvent(tableIdentifier, oldColumn, column, false, afterColumn);
    }

    @Override
    public EventType getEventType() {
        return EventType.SCHEMA_CHANGE_CHANGE_COLUMN;
    }

    public Column getColumn() {
        return this.column;
    }

    public boolean isFirst() {
        return this.first;
    }

    public String getAfterColumn() {
        return this.afterColumn;
    }

    public String getOldColumn() {
        return this.oldColumn;
    }

    @Override
    public String toString() {
        return "AlterTableChangeColumnEvent(super=" + super.toString() + ", column=" + this.getColumn() + ", first=" + this.isFirst() + ", afterColumn=" + this.getAfterColumn() + ", oldColumn=" + this.getOldColumn() + ")";
    }
}

