/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.tracing;

import java.util.Comparator;
import java.util.function.Supplier;
import org.apache.seatunnel.api.tracing.MDCContext;

public class MDCComparator<T>
implements Comparator<T> {
    private final Supplier<MDCContext> contextSupplier;
    private final Comparator<T> delegate;

    public MDCComparator(Comparator<T> delegate) {
        this(MDCContext.current(), delegate);
    }

    public MDCComparator(MDCContext context, Comparator<T> delegate) {
        this(() -> context, delegate);
    }

    public MDCComparator(Supplier<MDCContext> contextSupplier, Comparator<T> delegate) {
        this.contextSupplier = contextSupplier;
        this.delegate = delegate;
    }

    @Override
    public int compare(T o1, T o2) {
        try (MDCContext ignored = this.contextSupplier.get().activate();){
            int n = this.delegate.compare(o1, o2);
            return n;
        }
    }
}

