/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.tracing;

import java.io.Closeable;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MDCContext
implements Serializable,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(MDCContext.class);
    private static final MDCContext EMPTY = new MDCContext(null, null, null);
    private static final String EMPTY_TO_STRING = "NA";
    public static final String JOB_ID = "ST-JID";
    public static final String PIPELINE_ID = "ST-PID";
    public static final String TASK_ID = "ST-TID";
    private final Long jobId;
    private final Long pipelineId;
    private final Long taskId;
    private volatile transient MDCContext toRestore;

    public MDCContext(Long jobId, Long pipelineId, Long taskId) {
        this.jobId = jobId;
        this.pipelineId = pipelineId;
        this.taskId = taskId;
    }

    public synchronized MDCContext activate() {
        if (this == EMPTY) {
            return this;
        }
        if (this.toRestore != null) {
            throw new IllegalStateException("MDCContext is already activated");
        }
        this.toRestore = MDCContext.current();
        try {
            if (this.jobId != null) {
                MDC.put((String)JOB_ID, (String)String.valueOf(this.jobId));
            }
            if (this.pipelineId != null) {
                MDC.put((String)PIPELINE_ID, (String)String.valueOf(this.pipelineId));
            }
            if (this.taskId != null) {
                MDC.put((String)TASK_ID, (String)String.valueOf(this.taskId));
            }
        }
        catch (Throwable e) {
            log.error("Failed to put MDC context", e);
            throw e;
        }
        return this;
    }

    public synchronized MDCContext deactivate() {
        if (this == EMPTY) {
            return this;
        }
        if (this.toRestore == null) {
            throw new IllegalStateException("MDCContext is not activated");
        }
        try {
            MDC.remove((String)JOB_ID);
            MDC.remove((String)PIPELINE_ID);
            MDC.remove((String)TASK_ID);
        }
        catch (Throwable e) {
            log.error("Failed to clear MDC context", e);
            throw e;
        }
        if (this.toRestore != null) {
            this.toRestore.activate();
        }
        return this;
    }

    @Override
    public void close() {
        this.deactivate();
    }

    public String toString() {
        if (this == EMPTY) {
            return EMPTY_TO_STRING;
        }
        return String.format("%d/%d/%d", this.jobId, this.pipelineId == null ? 0L : this.pipelineId, this.taskId == null ? 0L : this.taskId);
    }

    public static MDCContext of(long jobId) {
        return new MDCContext(jobId, null, null);
    }

    public static MDCContext of(long jobId, long pipelineId) {
        return new MDCContext(jobId, pipelineId, null);
    }

    public static MDCContext of(long jobId, long pipelineId, long taskId) {
        return new MDCContext(jobId, pipelineId, taskId);
    }

    public static MDCContext of(MDCContext context) {
        return new MDCContext(context.jobId, context.pipelineId, context.taskId);
    }

    public static MDCContext current() {
        String jobId = MDC.get((String)JOB_ID);
        if (jobId == null) {
            return EMPTY;
        }
        String pipelineId = MDC.get((String)PIPELINE_ID);
        String taskId = MDC.get((String)TASK_ID);
        return new MDCContext(Long.parseLong(jobId), pipelineId != null ? Long.valueOf(Long.parseLong(pipelineId)) : null, taskId != null ? Long.valueOf(Long.parseLong(taskId)) : null);
    }

    public static MDCContext valueOf(String s) {
        if (EMPTY_TO_STRING.equals(s)) {
            return EMPTY;
        }
        String[] arr = s.split("/");
        Long jobId = Long.parseLong(arr[0]);
        Long pipelineId = Long.parseLong(arr[1]);
        Long taskId = Long.parseLong(arr[2]);
        if (pipelineId == 0L || taskId == 0L) {
            return MDCContext.of(jobId);
        }
        return MDCContext.of(jobId, pipelineId, taskId);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MDCContext)) {
            return false;
        }
        MDCContext other = (MDCContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$jobId = this.jobId;
        Long other$jobId = other.jobId;
        if (this$jobId == null ? other$jobId != null : !((Object)this$jobId).equals(other$jobId)) {
            return false;
        }
        Long this$pipelineId = this.pipelineId;
        Long other$pipelineId = other.pipelineId;
        if (this$pipelineId == null ? other$pipelineId != null : !((Object)this$pipelineId).equals(other$pipelineId)) {
            return false;
        }
        Long this$taskId = this.taskId;
        Long other$taskId = other.taskId;
        return !(this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MDCContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $jobId = this.jobId;
        result = result * 59 + ($jobId == null ? 43 : ((Object)$jobId).hashCode());
        Long $pipelineId = this.pipelineId;
        result = result * 59 + ($pipelineId == null ? 43 : ((Object)$pipelineId).hashCode());
        Long $taskId = this.taskId;
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        return result;
    }
}

