/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.tracing;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.seatunnel.api.tracing.MDCContext;

public class MDCPredicate<T>
implements Predicate<T> {
    private final Supplier<MDCContext> contextSupplier;
    private final Predicate<T> delegate;

    public MDCPredicate(Predicate<T> delegate) {
        this(MDCContext.current(), delegate);
    }

    public MDCPredicate(MDCContext context, Predicate<T> delegate) {
        this(() -> context, delegate);
    }

    public MDCPredicate(Supplier<MDCContext> contextSupplier, Predicate<T> delegate) {
        this.contextSupplier = contextSupplier;
        this.delegate = delegate;
    }

    @Override
    public boolean test(T t) {
        try (MDCContext ignored = this.contextSupplier.get().activate();){
            boolean bl = this.delegate.test(t);
            return bl;
        }
    }
}

