/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.tracing;

import java.util.function.Supplier;
import org.apache.seatunnel.api.tracing.MDCContext;

public class MDCRunnable
implements Runnable {
    private final Supplier<MDCContext> contextSupplier;
    private final Runnable delegate;

    public MDCRunnable(Runnable delegate) {
        this(MDCContext.current(), delegate);
    }

    public MDCRunnable(MDCContext context, Runnable delegate) {
        this(() -> context, delegate);
    }

    public MDCRunnable(Supplier<MDCContext> contextSupplier, Runnable delegate) {
        this.contextSupplier = contextSupplier;
        this.delegate = delegate;
    }

    @Override
    public void run() {
        try (MDCContext ignored = this.contextSupplier.get().activate();){
            this.delegate.run();
        }
    }
}

