/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.tracing;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.seatunnel.api.tracing.MDCCallable;
import org.apache.seatunnel.api.tracing.MDCContext;
import org.apache.seatunnel.api.tracing.MDCExecutorService;
import org.apache.seatunnel.api.tracing.MDCRunnable;

public class MDCScheduledExecutorService
extends MDCExecutorService
implements ScheduledExecutorService {
    private final MDCContext context;
    private final ScheduledExecutorService delegate;

    public MDCScheduledExecutorService(MDCContext context, ScheduledExecutorService delegate) {
        super(context, delegate);
        this.context = context;
        this.delegate = delegate;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.delegate.schedule(new MDCRunnable(() -> MDCContext.of(this.context), command), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.delegate.schedule(new MDCCallable<V>(() -> MDCContext.of(this.context), callable), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.delegate.scheduleAtFixedRate(new MDCRunnable(() -> MDCContext.of(this.context), command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.delegate.scheduleWithFixedDelay(new MDCRunnable(() -> MDCContext.of(this.context), command), initialDelay, delay, unit);
    }
}

