/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;

public interface BasicTypeConverter<T extends BasicTypeDefine>
extends TypeConverter<T> {
    default public List<T> reconvert(CatalogTable table, String ... identifiers) {
        ArrayList<BasicTypeDefine> typeDefines = new ArrayList<BasicTypeDefine>();
        for (Column column : table.getTableSchema().getColumns()) {
            BasicTypeDefine t = (BasicTypeDefine)this.reconvert(column);
            if (table.getCatalogName().equals(this.identifier())) {
                t.setColumnType(column.getSourceType());
            }
            if (identifiers != null) {
                Arrays.asList(identifiers).forEach(id -> {
                    if (id.equals(t.getName())) {
                        t.setColumnType(column.getSourceType());
                    }
                });
            }
            typeDefines.add(t);
        }
        return typeDefines;
    }
}

