/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.config;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.common.config.DeployMode;

public class Common {
    public static final int COLLECTION_SIZE = 16;
    private static final int APP_LIB_DIR_DEPTH = 2;
    private static final int PLUGIN_LIB_DIR_DEPTH = 3;
    private static DeployMode MODE;
    private static boolean STARTER;

    private Common() {
        throw new IllegalStateException("Utility class");
    }

    public static void setDeployMode(DeployMode mode) {
        MODE = mode;
    }

    public static void setStarter(boolean inStarter) {
        STARTER = inStarter;
    }

    public static DeployMode getDeployMode() {
        return MODE;
    }

    public static Path appRootDir() {
        if (DeployMode.CLIENT == MODE || STARTER) {
            try {
                String path = Common.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                path = new File(path).getPath();
                return Paths.get(path, new String[0]).getParent().getParent();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (DeployMode.CLUSTER == MODE) {
            return Paths.get("", new String[0]);
        }
        throw new IllegalStateException("deploy mode not support : " + (Object)((Object)MODE));
    }

    public static Path appStarterDir() {
        return Common.appRootDir().resolve("starter");
    }

    public static Path pluginRootDir() {
        return Paths.get(Common.appRootDir().toString(), "plugins");
    }

    public static Path connectorRootDir(String engine) {
        return Paths.get(Common.appRootDir().toString(), "connectors", engine.toLowerCase());
    }

    public static Path connectorJarDir(String engine) {
        String seatunnelHome = System.getProperty("SEATUNNEL_HOME");
        if (StringUtils.isBlank((CharSequence)seatunnelHome)) {
            return Paths.get(Common.appRootDir().toString(), "connectors", engine.toLowerCase());
        }
        return Paths.get(seatunnelHome, "connectors", engine.toLowerCase());
    }

    public static Path connectorDir() {
        String seatunnelHome = System.getProperty("SEATUNNEL_HOME");
        if (StringUtils.isBlank((CharSequence)seatunnelHome)) {
            return Paths.get(Common.appRootDir().toString(), "connectors");
        }
        return Paths.get(seatunnelHome, "connectors");
    }

    public static Path libDir() {
        String seatunnelHome = System.getProperty("SEATUNNEL_HOME");
        if (StringUtils.isBlank((CharSequence)seatunnelHome)) {
            seatunnelHome = Common.appRootDir().toString();
        }
        return Paths.get(seatunnelHome, "lib");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Path> getLibJars() {
        Path libRootDir = Common.libDir();
        if (!Files.exists(libRootDir, new LinkOption[0])) return Collections.emptyList();
        if (!Files.isDirectory(libRootDir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try (Stream<Path> stream = Files.walk(libRootDir, 2, FileVisitOption.FOLLOW_LINKS);){
            List<Path> list = stream.filter(it -> !it.toFile().isDirectory()).filter(it -> it.getFileName().toString().endsWith(".jar")).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Set<Path> getThirdPartyJars(String paths) {
        return Arrays.stream(paths.split(";")).filter(s -> !"".equals(s)).filter(it -> it.endsWith(".jar")).map(path -> Paths.get(URI.create(path))).collect(Collectors.toSet());
    }

    public static Path pluginTarball() {
        return Common.appRootDir().resolve("plugins.tar.gz");
    }

    public static Path pluginDir(String pluginName) {
        return Paths.get(Common.pluginRootDir().toString(), pluginName);
    }

    public static Path pluginFilesDir(String pluginName) {
        return Paths.get(Common.pluginDir(pluginName).toString(), "files");
    }

    public static Path pluginLibDir(String pluginName) {
        return Paths.get(Common.pluginDir(pluginName).toString(), "lib");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Path> getPluginsJarDependencies() {
        Path pluginRootDir = Common.pluginRootDir();
        if (!Files.exists(pluginRootDir, new LinkOption[0])) return Collections.emptyList();
        if (!Files.isDirectory(pluginRootDir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try (Stream<Path> stream = Files.walk(pluginRootDir, 3, FileVisitOption.FOLLOW_LINKS);){
            List<Path> list = stream.filter(it -> pluginRootDir.relativize((Path)it).getNameCount() == 3).filter(it -> it.getParent().endsWith("lib")).filter(it -> it.getFileName().toString().endsWith(".jar")).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        STARTER = false;
    }
}

