/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;

public final class TypesafeConfigUtils {
    private TypesafeConfigUtils() {
    }

    public static boolean hasSubConfig(Config source, String prefix) {
        boolean hasConfig = false;
        for (Map.Entry entry : source.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix)) continue;
            hasConfig = true;
            break;
        }
        return hasConfig;
    }

    public static <T> T getConfig(Config config, String configKey, T defaultValue) {
        if (!config.hasPath(configKey) && defaultValue == null) {
            return defaultValue;
        }
        if (defaultValue.getClass().equals(Long.class)) {
            return (T)(config.hasPath(configKey) ? Long.valueOf(config.getString(configKey)) : defaultValue);
        }
        if (defaultValue.getClass().equals(Integer.class)) {
            return (T)(config.hasPath(configKey) ? Integer.valueOf(config.getString(configKey)) : defaultValue);
        }
        if (defaultValue.getClass().equals(String.class)) {
            return (T)(config.hasPath(configKey) ? config.getString(configKey) : defaultValue);
        }
        if (defaultValue.getClass().equals(Boolean.class)) {
            return (T)(config.hasPath(configKey) ? Boolean.valueOf(config.getString(configKey)) : defaultValue);
        }
        if (defaultValue instanceof Map || defaultValue instanceof List) {
            return (T)(config.hasPath(configKey) ? config.getAnyRef(configKey) : defaultValue);
        }
        throw new RuntimeException("Unsupported config type, configKey: " + configKey);
    }

    public static List<? extends Config> getConfigList(Config config, String configKey, @NonNull List<? extends Config> defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return config.hasPath(configKey) ? config.getConfigList(configKey) : defaultValue;
    }

    public static Map<String, String> configToMap(Config config) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        config.entrySet().forEach(entry -> configMap.put((String)entry.getKey(), ((ConfigValue)entry.getValue()).unwrapped().toString()));
        return configMap;
    }
}

