/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.exception;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.map.SingletonMap;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;

public class CommonError {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static SeaTunnelRuntimeException fileOperationFailed(String identifier, String operation, String fileName, Throwable cause) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        params.put("operation", operation);
        params.put("fileName", fileName);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.FILE_OPERATION_FAILED, params, cause);
    }

    public static SeaTunnelRuntimeException fileOperationFailed(String identifier, String operation, String fileName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        params.put("operation", operation);
        params.put("fileName", fileName);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.FILE_OPERATION_FAILED, params);
    }

    public static SeaTunnelRuntimeException fileNotExistFailed(String identifier, String operation, String fileName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        params.put("operation", operation);
        params.put("fileName", fileName);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.FILE_NOT_EXISTED, params);
    }

    public static SeaTunnelRuntimeException writeSeaTunnelRowFailed(String connector, String row, Throwable cause) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("connector", connector);
        params.put("seaTunnelRow", row);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.WRITE_SEATUNNEL_ROW_ERROR, params, cause);
    }

    public static SeaTunnelRuntimeException unsupportedDataType(String identifier, String dataType, String field) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        params.put("dataType", dataType);
        params.put("field", field);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, params);
    }

    public static SeaTunnelRuntimeException unsupportedVersion(String identifier, String version) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        params.put("version", version);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.VERSION_NOT_SUPPORTED, params);
    }

    public static SeaTunnelRuntimeException unsupportedEncoding(String encoding) {
        SingletonMap params = new SingletonMap((Object)"encoding", (Object)encoding);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_ENCODING, (Map<String, String>)params);
    }

    public static SeaTunnelRuntimeException convertToSeaTunnelTypeError(String connector, PluginType pluginType, String dataType, String field) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("connector", connector);
        params.put("type", pluginType.getType());
        params.put("dataType", dataType);
        params.put("field", field);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.CONVERT_TO_SEATUNNEL_TYPE_ERROR, params);
    }

    public static SeaTunnelRuntimeException convertToSeaTunnelTypeError(String identifier, String dataType, String field) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        params.put("dataType", dataType);
        params.put("field", field);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.CONVERT_TO_SEATUNNEL_TYPE_ERROR_SIMPLE, params);
    }

    public static SeaTunnelRuntimeException convertToConnectorTypeError(String connector, PluginType pluginType, String dataType, String field) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("connector", connector);
        params.put("type", pluginType.getType());
        params.put("dataType", dataType);
        params.put("field", field);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.CONVERT_TO_CONNECTOR_TYPE_ERROR, params);
    }

    public static SeaTunnelRuntimeException convertToConnectorPropsBlankError(String connector, String props) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("connector", connector);
        params.put("props", props);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.CONVERT_TO_SEATUNNEL_PROPS_BLANK_ERROR, params);
    }

    public static SeaTunnelRuntimeException convertToConnectorTypeError(String identifier, String dataType, String field) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        params.put("dataType", dataType);
        params.put("field", field);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.CONVERT_TO_CONNECTOR_TYPE_ERROR_SIMPLE, params);
    }

    public static SeaTunnelRuntimeException getCatalogTableWithUnsupportedType(String catalogName, String tableName, Map<String, String> fieldWithDataTypes) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("catalogName", catalogName);
        params.put("tableName", tableName);
        try {
            params.put("fieldWithDataTypes", OBJECT_MAPPER.writeValueAsString(fieldWithDataTypes));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.GET_CATALOG_TABLE_WITH_UNSUPPORTED_TYPE_ERROR, params);
    }

    public static SeaTunnelRuntimeException getCatalogTablesWithUnsupportedType(String catalogName, Map<String, Map<String, String>> tableUnsupportedTypes) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("catalogName", catalogName);
        try {
            params.put("tableUnsupportedTypes", OBJECT_MAPPER.writeValueAsString(tableUnsupportedTypes));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.GET_CATALOG_TABLES_WITH_UNSUPPORTED_TYPE_ERROR, params);
    }

    public static SeaTunnelRuntimeException jsonOperationError(String identifier, String payload) {
        return CommonError.jsonOperationError(identifier, payload, null);
    }

    public static SeaTunnelRuntimeException jsonOperationError(String identifier, String payload, Throwable cause) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        params.put("payload", payload);
        CommonErrorCode code = CommonErrorCode.JSON_OPERATION_FAILED;
        if (cause != null) {
            return new SeaTunnelRuntimeException((SeaTunnelErrorCode)code, params, cause);
        }
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)code, params);
    }

    public static SeaTunnelRuntimeException unsupportedOperation(String identifier, String operation) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        params.put("operation", operation);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.OPERATION_NOT_SUPPORTED, params);
    }

    public static SeaTunnelRuntimeException sqlTemplateHandledError(String tableName, String keyName, String template, String placeholder, String optionName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tableName", tableName);
        params.put("keyName", keyName);
        params.put("template", template);
        params.put("placeholder", placeholder);
        params.put("optionName", optionName);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.SQL_TEMPLATE_HANDLED_ERROR, params);
    }

    public static SeaTunnelRuntimeException unsupportedArrayGenericType(String identifier, String dataType, String fieldName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        params.put("dataType", dataType);
        params.put("fieldName", fieldName);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_ARRAY_GENERIC_TYPE, params);
    }

    public static SeaTunnelRuntimeException unsupportedRowKind(String identifier, String tableId, String rowKind) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        params.put("tableId", tableId);
        params.put("rowKind", rowKind);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_ROW_KIND, params);
    }

    public static SeaTunnelRuntimeException writeRowErrorWithSchemaIncompatibleSchema(String connector, String sourceFieldSqlSchema, String exceptFieldSqlSchema, String sinkFieldSqlSchema) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("connector", connector);
        params.put("sourceFieldSqlSchema", sourceFieldSqlSchema);
        params.put("exceptFieldSqlSchema", exceptFieldSqlSchema);
        params.put("sinkFieldSqlSchema", sinkFieldSqlSchema);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.WRITE_SEATUNNEL_ROW_ERROR_WITH_SCHEMA_INCOMPATIBLE_SCHEMA, params);
    }

    public static SeaTunnelRuntimeException writeRowErrorWithFiledsCountNotMatch(String connector, int sourceFieldsNum, int sinkFieldsNum) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("connector", connector);
        params.put("sourceFieldsNum", String.valueOf(sourceFieldsNum));
        params.put("sinkFieldsNum", String.valueOf(sinkFieldsNum));
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.WRITE_SEATUNNEL_ROW_ERROR_WITH_FILEDS_NOT_MATCH, params);
    }

    public static SeaTunnelRuntimeException formatDateTimeError(String datetime, String field) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("datetime", datetime);
        params.put("field", field);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.FORMAT_DATETIME_ERROR, params);
    }

    public static SeaTunnelRuntimeException formatDateError(String date, String field) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("date", date);
        params.put("field", field);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.FORMAT_DATE_ERROR, params);
    }

    public static SeaTunnelRuntimeException unsupportedMethod(String identifier, String methodName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        params.put("methodName", methodName);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_METHOD, params);
    }

    public static SeaTunnelRuntimeException illegalArgument(String argument, String operation) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("argument", argument);
        params.put("operation", operation);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.ILLEGAL_ARGUMENT, params);
    }

    public static SeaTunnelRuntimeException closeFailed(String identifier, Throwable cause) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identifier", identifier);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.CLOSE_FAILED, params, cause);
    }

    public static SeaTunnelRuntimeException seatunnelRowSerializeFailed(String row, Throwable cause) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("row", row);
        return new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.SEATUNNEL_ROW_SERIALIZE_FAILED, params, cause);
    }
}

