/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.utils;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class TimeUtils {
    private static final Map<Formatter, DateTimeFormatter> FORMATTER_MAP = new HashMap<Formatter, DateTimeFormatter>();
    public static final Pattern[] PATTERN_ARRAY;
    public static final Map<Pattern, Formatter> Time_FORMATTER_MAP;

    public static LocalTime parse(String time, Formatter formatter) {
        return LocalTime.parse(time, FORMATTER_MAP.get((Object)formatter));
    }

    public static LocalTime parse(String dateTime) {
        return LocalTime.parse(dateTime, FORMATTER_MAP.get((Object)TimeUtils.matchTimeFormatter(dateTime)));
    }

    public static Formatter matchTimeFormatter(String dateTime) {
        for (int j = 0; j < PATTERN_ARRAY.length; ++j) {
            if (!PATTERN_ARRAY[j].matcher(dateTime).matches()) continue;
            Formatter dateTimeFormatter = Time_FORMATTER_MAP.get(PATTERN_ARRAY[j]);
            return dateTimeFormatter;
        }
        return null;
    }

    public static String toString(LocalTime time, Formatter formatter) {
        return time.format(FORMATTER_MAP.get((Object)formatter));
    }

    static {
        FORMATTER_MAP.put(Formatter.HH_MM_SS, DateTimeFormatter.ofPattern(Formatter.HH_MM_SS.value));
        FORMATTER_MAP.put(Formatter.HH_MM_SS_SSS, DateTimeFormatter.ofPattern(Formatter.HH_MM_SS_SSS.value));
        PATTERN_ARRAY = new Pattern[]{Pattern.compile("\\d{2}:\\d{2}:\\d{2}"), Pattern.compile("\\d{2}:\\d{2}:\\d{2}.\\d{3}")};
        Time_FORMATTER_MAP = new HashMap<Pattern, Formatter>();
        Time_FORMATTER_MAP.put(PATTERN_ARRAY[0], Formatter.parse(Formatter.HH_MM_SS.value));
        Time_FORMATTER_MAP.put(PATTERN_ARRAY[1], Formatter.parse(Formatter.HH_MM_SS_SSS.value));
    }

    public static enum Formatter {
        HH_MM_SS("HH:mm:ss"),
        HH_MM_SS_SSS("HH:mm:ss.SSS");

        private final String value;

        private Formatter(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Formatter parse(String format) {
            Formatter[] formatters;
            for (Formatter formatter : formatters = Formatter.values()) {
                if (!formatter.getValue().equals(format)) continue;
                return formatter;
            }
            String errorMsg = String.format("Illegal format [%s]", format);
            throw new IllegalArgumentException(errorMsg);
        }
    }
}

