/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonParser;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JavaType;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.MapperFeature;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.Module;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.JsonNodeType;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.TextNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.type.CollectionType;
import org.apache.seatunnel.shade.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

public class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true).configure(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS, true).setTimeZone(TimeZone.getDefault()).registerModule((Module)new JavaTimeModule());
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper();

    private JsonUtils() {
        throw new UnsupportedOperationException("Construct JSONUtils");
    }

    public static ArrayNode createArrayNode() {
        return OBJECT_MAPPER.createArrayNode();
    }

    public static ObjectNode createObjectNode() {
        return OBJECT_MAPPER.createObjectNode();
    }

    public static JsonNode toJsonNode(Object obj) {
        return OBJECT_MAPPER.valueToTree(obj);
    }

    public static JsonNode stringToJsonNode(String obj) throws JsonProcessingException {
        return OBJECT_MAPPER.readTree(obj);
    }

    public static JsonNode readTree(byte[] obj) throws IOException {
        return OBJECT_MAPPER.readTree(obj);
    }

    public static String toJsonString(Object object, SerializationFeature feature) {
        try {
            ObjectWriter writer = OBJECT_MAPPER.writer(feature);
            return writer.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new RuntimeException("Object to json exception!", e);
        }
    }

    public static <T> T parseObject(String json, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("Json parse object exception!", e);
        }
    }

    public static <T> List<T> toList(String json, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return Collections.emptyList();
        }
        try {
            CollectionType listType = OBJECT_MAPPER.getTypeFactory().constructCollectionType(ArrayList.class, clazz);
            return (List)OBJECT_MAPPER.readValue(json, (JavaType)listType);
        }
        catch (Exception e) {
            throw new RuntimeException("Json parse list exception!", e);
        }
    }

    public static String findValue(JsonNode jsonNode, String fieldName) {
        JsonNode node = jsonNode.findValue(fieldName);
        if (node == null) {
            return null;
        }
        return node.asText();
    }

    public static Map<String, String> toMap(String json) {
        return JsonUtils.parseObject(json, new TypeReference<Map<String, String>>(){});
    }

    public static Map<String, Object> toMap(JsonNode jsonNode) {
        return (Map)DEFAULT_OBJECT_MAPPER.convertValue((Object)jsonNode, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static Map<String, String> toStringMap(JsonNode jsonNode) {
        LinkedHashMap<String, String> fieldsMap = new LinkedHashMap<String, String>();
        jsonNode.fields().forEachRemaining(field -> {
            String key = (String)field.getKey();
            JsonNode value = (JsonNode)field.getValue();
            if (value.getNodeType() == JsonNodeType.OBJECT) {
                fieldsMap.put(key, value.toString());
            } else {
                fieldsMap.put(key, value.textValue());
            }
        });
        return fieldsMap;
    }

    public static <K, V> Map<K, V> toMap(String json, Class<K> classK, Class<V> classV) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return Collections.emptyMap();
        }
        try {
            return (Map)OBJECT_MAPPER.readValue(json, new TypeReference<Map<K, V>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException("json to map exception!", e);
        }
    }

    public static <T> T parseObject(String json, TypeReference<T> type) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(json, type);
        }
        catch (Exception e) {
            throw new RuntimeException("Json parse object exception.", e);
        }
    }

    public static String toJsonString(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new RuntimeException("Object json deserialization exception.", e);
        }
    }

    public static ObjectNode parseObject(String text) {
        return JsonUtils.parseObject(text.getBytes());
    }

    public static ObjectNode parseObject(byte[] content) {
        try {
            return (ObjectNode)OBJECT_MAPPER.readTree(content);
        }
        catch (IOException e) {
            throw new RuntimeException("String json deserialization exception." + new String(content), e);
        }
    }

    public static ArrayNode parseArray(String text) {
        try {
            return (ArrayNode)OBJECT_MAPPER.readTree(text);
        }
        catch (Exception e) {
            throw new RuntimeException("Json deserialization exception.", e);
        }
    }

    public static boolean isJsonArray(String jsonString) {
        try {
            JsonNode jsonNode = OBJECT_MAPPER.readTree(jsonString);
            return jsonNode.isArray();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class JsonDataDeserializer
    extends JsonDeserializer<String> {
        public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            if (node instanceof TextNode) {
                return node.asText();
            }
            return node.toString();
        }
    }

    public static class JsonDataSerializer
    extends JsonSerializer<String> {
        public void serialize(String value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeRawValue(value);
        }
    }
}

