/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.mr;

import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.elasticsearch.hadoop.mr.Counter;
import org.elasticsearch.hadoop.mr.compat.CompatHandler;
import org.elasticsearch.hadoop.mr.compat.TaskInputOutputContext;
import org.elasticsearch.hadoop.rest.stats.Stats;

class ReportingUtils {
    ReportingUtils() {
    }

    static void report(Progressable progressable, Stats stats) {
        if ((progressable = (Progressable)CompatHandler.unwrap(progressable)) == null || progressable == Reporter.NULL) {
            return;
        }
        if (progressable instanceof Reporter) {
            Reporter reporter = (Reporter)progressable;
            for (Counter count2 : Counter.ALL) {
                ReportingUtils.oldApiCounter(reporter, count2, count2.get(stats));
            }
        }
        if (progressable instanceof org.apache.hadoop.mapreduce.TaskInputOutputContext) {
            TaskInputOutputContext compatTioc = CompatHandler.taskInputOutputContext((org.apache.hadoop.mapreduce.TaskInputOutputContext)progressable);
            for (Counter count2 : Counter.ALL) {
                ReportingUtils.newApiCounter(compatTioc, count2, count2.get(stats));
            }
        }
    }

    private static void oldApiCounter(Reporter reporter, Enum<?> counter, long value) {
        try {
            Counters.Counter c = reporter.getCounter(counter);
            if (c != null) {
                c.increment(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void newApiCounter(TaskInputOutputContext tioc, Enum<?> counter, long value) {
        try {
            org.apache.hadoop.mapreduce.Counter c = tioc.getCounter(counter);
            if (c != null) {
                CompatHandler.counter(c).increment(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

