/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.pooling;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.TransportFactory;
import org.elasticsearch.hadoop.rest.pooling.PooledHttpTransportFactory;
import org.elasticsearch.hadoop.util.SettingsUtils;

public final class PooledTransportManager {
    private static final Log LOG = LogFactory.getLog(PooledTransportManager.class);
    private static final ConcurrentMap<String, PooledHttpTransportFactory> poolRegistry = new ConcurrentHashMap<String, PooledHttpTransportFactory>();

    private PooledTransportManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TransportFactory getTransportFactory(Settings jobSettings) {
        SettingsUtils.ensureJobTransportPoolingKey(jobSettings);
        String jobKey = SettingsUtils.getJobTransportPoolingKey(jobSettings);
        PooledHttpTransportFactory factoryForJob = (PooledHttpTransportFactory)poolRegistry.get(jobKey);
        if (factoryForJob != null) return factoryForJob;
        Class<PooledTransportManager> clazz = PooledTransportManager.class;
        synchronized (PooledTransportManager.class) {
            factoryForJob = (PooledHttpTransportFactory)poolRegistry.get(jobKey);
            if (factoryForJob != null) return factoryForJob;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating new PooledTransportFactory for job key [" + jobKey + "]"));
            }
            factoryForJob = new PooledHttpTransportFactory(jobKey);
            poolRegistry.put(jobKey, factoryForJob);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return factoryForJob;
        }
    }

    static {
        Thread cleanup = new Thread(new PoolCleaner());
        cleanup.setDaemon(true);
        cleanup.start();
    }

    private static class PoolCleaner
    implements Runnable {
        private final Log log = LogFactory.getLog(this.getClass());
        private final long cleaningInterval = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);

        private PoolCleaner() {
        }

        @Override
        public void run() {
            this.log.trace((Object)"Started PoolCleaner...");
            try {
                block2: while (true) {
                    this.log.trace((Object)"Waiting");
                    Thread.sleep(this.cleaningInterval);
                    this.log.trace((Object)"Cleaning...");
                    Iterator iterator2 = poolRegistry.entrySet().iterator();
                    while (true) {
                        if (!iterator2.hasNext()) continue block2;
                        Map.Entry entry = iterator2.next();
                        ((PooledHttpTransportFactory)entry.getValue()).cleanPools();
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

