/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.field;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.SettingsAware;
import org.elasticsearch.hadoop.serialization.bulk.RawJson;
import org.elasticsearch.hadoop.serialization.field.FieldExplainer;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.StringUtils;

public abstract class AbstractDefaultParamsExtractor
implements FieldExtractor,
SettingsAware,
FieldExplainer {
    private final Map<String, FieldExtractor> params = new LinkedHashMap<String, FieldExtractor>();
    protected Settings settings;
    private FieldExtractor lastFailingFieldExtractor;

    @Override
    public Object field(Object target) {
        ArrayList<Object> list = new ArrayList<Object>(this.params.size());
        int entries = 0;
        list.add(new RawJson("{"));
        for (Map.Entry<String, FieldExtractor> entry : this.params.entrySet()) {
            String val = StringUtils.toJsonString(entry.getKey()) + ":";
            if (entries > 0) {
                val = "," + val;
            }
            list.add(new RawJson(val));
            Object field2 = entry.getValue().field(target);
            if (field2 == FieldExtractor.NOT_FOUND) {
                this.lastFailingFieldExtractor = entry.getValue();
                return FieldExtractor.NOT_FOUND;
            }
            list.add(field2);
            ++entries;
        }
        list.add(new RawJson("}"));
        return list;
    }

    @Override
    public String toString(Object target) {
        return this.lastFailingFieldExtractor instanceof FieldExplainer ? ((FieldExplainer)((Object)this.lastFailingFieldExtractor)).toString(target) : target.toString();
    }

    @Override
    public void setSettings(Settings settings) {
        this.settings = settings;
        String paramString = settings.getUpdateScriptParams();
        List<String> fields = StringUtils.tokenize(paramString);
        for (String string2 : fields) {
            List<String> param2 = StringUtils.tokenize(string2, ":");
            Assert.isTrue(param2.size() == 2, "Invalid param definition " + string2);
            this.params.put(param2.get(0), this.createFieldExtractor(param2.get(1)));
        }
    }

    public String toString() {
        if (this.lastFailingFieldExtractor != null) {
            return this.lastFailingFieldExtractor.toString();
        }
        return String.format("%s for fields [%s]", this.getClass().getSimpleName(), this.params.keySet());
    }

    protected abstract FieldExtractor createFieldExtractor(String var1);
}

