/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.rdd;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.TaskContext;
import org.elasticsearch.hadoop.cfg.PropertiesSettings;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.mr.security.HadoopUserProvider;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.RestService;
import org.elasticsearch.hadoop.security.UserProvider;
import org.elasticsearch.hadoop.serialization.BytesConverter;
import org.elasticsearch.hadoop.serialization.JdkBytesConverter;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.serialization.bulk.MetadataExtractor;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.spark.rdd.EsRDDWriter$;
import org.elasticsearch.spark.serialization.ScalaMapFieldExtractor;
import org.elasticsearch.spark.serialization.ScalaMetadataExtractor;
import org.elasticsearch.spark.serialization.ScalaValueWriter;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005mh!B\u0001\u0003\u0001\u0011Q!aC#t%\u0012#uK]5uKJT!a\u0001\u0003\u0002\u0007I$GM\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u000eK2\f7\u000f^5dg\u0016\f'o\u00195\u000b\u0003%\t1a\u001c:h+\tYAgE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\u0007\u0014\u0013\t!bB\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0017\u0001\t\u0015\r\u0011\"\u0001\u0019\u0003I\u0019XM]5bY&TX\rZ*fiRLgnZ:\u0004\u0001U\t\u0011\u0004\u0005\u0002\u001b;9\u0011QbG\u0005\u000399\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0010 \u0005\u0019\u0019FO]5oO*\u0011AD\u0004\u0005\tC\u0001\u0011\t\u0011)A\u00053\u0005\u00192/\u001a:jC2L'0\u001a3TKR$\u0018N\\4tA!A1\u0005\u0001BC\u0002\u0013\u0005A%A\bsk:$\u0018.\\3NKR\fG-\u0019;b+\u0005)\u0003CA\u0007'\u0013\t9cBA\u0004C_>dW-\u00198\t\u0011%\u0002!\u0011!Q\u0001\n\u0015\n\u0001C];oi&lW-T3uC\u0012\fG/\u0019\u0011\t\u0011-\u0002!1!Q\u0001\f1\n!\"\u001a<jI\u0016t7-\u001a\u00132!\ri\u0003GM\u0007\u0002])\u0011qFD\u0001\be\u00164G.Z2u\u0013\t\tdF\u0001\u0005DY\u0006\u001c8\u000fV1h!\t\u0019D\u0007\u0004\u0001\u0005\u000bU\u0002!\u0019\u0001\u001c\u0003\u0003Q\u000b\"a\u000e\u001e\u0011\u00055A\u0014BA\u001d\u000f\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!D\u001e\n\u0005qr!aA!os\")a\b\u0001C\u0001\u007f\u00051A(\u001b8jiz\"2\u0001\u0011#F)\t\t5\tE\u0002C\u0001Ij\u0011A\u0001\u0005\u0006Wu\u0002\u001d\u0001\f\u0005\u0006-u\u0002\r!\u0007\u0005\bGu\u0002\n\u00111\u0001&\u0011!9\u0005\u0001#b\u0001\n#A\u0015a\u00017pOV\t\u0011\n\u0005\u0002K#6\t1J\u0003\u0002M\u001b\u00069An\\4hS:<'B\u0001(P\u0003\u001d\u0019w.\\7p]NT!\u0001\u0015\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\u00116JA\u0002M_\u001eD\u0001\u0002\u0016\u0001\t\u0002\u0003\u0006K!S\u0001\u0005Y><\u0007\u0005\u000b\u0002T-B\u0011QbV\u0005\u00031:\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u0011i\u0003\u0001R1A\u0005\u0002m\u000b\u0001b]3ui&twm]\u000b\u00029B\u0011QLY\u0007\u0002=*\u0011q\fY\u0001\u0004G\u001a<'BA1\u0007\u0003\u0019A\u0017\rZ8pa&\u00111M\u0018\u0002\t'\u0016$H/\u001b8hg\"AQ\r\u0001E\u0001B\u0003&A,A\u0005tKR$\u0018N\\4tA!Aq\r\u0001EC\u0002\u0013\u0005\u0001.A\u0007nKR\fW\t\u001f;sC\u000e$xN]\u000b\u0002SB\u0011!n\\\u0007\u0002W*\u0011A.\\\u0001\u0005EVd7N\u0003\u0002oA\u0006i1/\u001a:jC2L'0\u0019;j_:L!\u0001]6\u0003#5+G/\u00193bi\u0006,\u0005\u0010\u001e:bGR|'\u000f\u0003\u0005s\u0001!\u0005\t\u0015)\u0003j\u00039iW\r^1FqR\u0014\u0018m\u0019;pe\u0002BQ\u0001\u001e\u0001\u0005\u0002U\fQa\u001e:ji\u0016$BA^=\u0002\u0002A\u0011Qb^\u0005\u0003q:\u0011A!\u00168ji\")!p\u001da\u0001w\u0006YA/Y:l\u0007>tG/\u001a=u!\tah0D\u0001~\u0015\t)q*\u0003\u0002\u0000{\nYA+Y:l\u0007>tG/\u001a=u\u0011\u001d\t\u0019a\u001da\u0001\u0003\u000b\tA\u0001Z1uCB)\u0011qAA\fe9!\u0011\u0011BA\n\u001d\u0011\tY!!\u0005\u000e\u0005\u00055!bAA\b/\u00051AH]8pizJ\u0011aD\u0005\u0004\u0003+q\u0011a\u00029bG.\fw-Z\u0005\u0005\u00033\tYB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\t)B\u0004\u0005\b\u0003?\u0001A\u0011CA\u0011\u0003-1\u0018\r\\;f/JLG/\u001a:\u0016\u0005\u0005\r\u0002\u0007BA\u0013\u0003[\u0001RAGA\u0014\u0003WI1!!\u000b \u0005\u0015\u0019E.Y:t!\r\u0019\u0014Q\u0006\u0003\r\u0003_\ti\"!A\u0001\u0002\u000b\u0005\u0011\u0011\u0007\u0002\u0004?\u0012\n\u0014cA\u001c\u00024A\"\u0011QGA\"!\u0019\t9$!\u0010\u0002B5\u0011\u0011\u0011\b\u0006\u0004\u0003wi\u0017a\u00022vS2$WM]\u0005\u0005\u0003\u007f\tIDA\u0006WC2,Xm\u0016:ji\u0016\u0014\bcA\u001a\u0002D\u0011Y\u0011QIA$\u0003\u0003\u0005\tQ!\u00017\u0005\ryFE\r\u0003\r\u0003_\ti\"!A\u0002\u0002\u000b\u0005\u0011\u0011\u0007\u0005\b\u0003\u0017\u0002A\u0011CA'\u00039\u0011\u0017\u0010^3t\u0007>tg/\u001a:uKJ,\"!a\u00141\t\u0005E\u0013Q\u000b\t\u00065\u0005\u001d\u00121\u000b\t\u0004g\u0005UC\u0001DA,\u0003\u0013\n\t\u0011!A\u0003\u0002\u0005e#aA0%gE\u0019q'a\u0017\u0011\t\u0005u\u0013qL\u0007\u0002[&\u0019\u0011\u0011M7\u0003\u001d\tKH/Z:D_:4XM\u001d;fe\"9\u0011Q\r\u0001\u0005\u0012\u0005\u001d\u0014A\u00044jK2$W\t\u001f;sC\u000e$xN]\u000b\u0003\u0003S\u0002D!a\u001b\u0002pA)!$a\n\u0002nA\u00191'a\u001c\u0005\u0019\u0005E\u00141MA\u0001\u0002\u0003\u0015\t!a\u001d\u0003\u0007}#C'E\u00028\u0003k\u0002B!a\u001e\u0002~5\u0011\u0011\u0011\u0010\u0006\u0004\u0003wj\u0017!\u00024jK2$\u0017\u0002BA@\u0003s\u0012aBR5fY\u0012,\u0005\u0010\u001e:bGR|'\u000fC\u0004\u0002\u0004\u0002!\t\"!\"\u0002#5,G/\u00193bi\u0006,\u0005\u0010\u001e:bGR|'/\u0006\u0002\u0002\bB\"\u0011\u0011RAG!\u0015Q\u0012qEAF!\r\u0019\u0014Q\u0012\u0003\r\u0003\u001f\u000b\t)!A\u0001\u0002\u000b\u0005\u0011\u0011\u0013\u0002\u0004?\u0012*\u0014CA\u001cj\u0011\u001d\t)\n\u0001C\t\u0003/\u000bA\"^:feB\u0013xN^5eKJ,\"!!'1\t\u0005m\u0015q\u0014\t\u00065\u0005\u001d\u0012Q\u0014\t\u0004g\u0005}E\u0001DAQ\u0003'\u000b\t\u0011!A\u0003\u0002\u0005\r&aA0%mE\u0019q'!*\u0011\t\u0005\u001d\u0016QV\u0007\u0003\u0003SS1!a+a\u0003!\u0019XmY;sSRL\u0018\u0002BAX\u0003S\u0013A\"V:feB\u0013xN^5eKJDq!a-\u0001\t#\t),A\u0006qe>\u001cWm]:ECR\fGc\u0001\u001e\u00028\"A\u00111AAY\u0001\u0004\t)a\u0002\u0006\u0002<\n\t\t\u0011#\u0001\u0005\u0003{\u000b1\"R:S\t\u0012;&/\u001b;feB\u0019!)a0\u0007\u0013\u0005\u0011\u0011\u0011!E\u0001\t\u0005\u00057\u0003BA`\u0019IAqAPA`\t\u0003\t)\r\u0006\u0002\u0002>\"Q\u0011\u0011ZA`#\u0003%\t!a3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0011\ti-a9\u0016\u0005\u0005='fA\u0013\u0002R.\u0012\u00111\u001b\t\u0005\u0003+\fy.\u0004\u0002\u0002X*!\u0011\u0011\\An\u0003%)hn\u00195fG.,GMC\u0002\u0002^:\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\t/a6\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0002\u00046\u0003\u000f\u0014\rA\u000e\u0005\u000b\u0003O\fy,!A\u0005\n\u0005%\u0018a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a;\u0011\t\u00055\u0018q_\u0007\u0003\u0003_TA!!=\u0002t\u0006!A.\u00198h\u0015\t\t)0\u0001\u0003kCZ\f\u0017\u0002BA}\u0003_\u0014aa\u00142kK\u000e$\b")
public class EsRDDWriter<T>
implements Serializable {
    private final String serializedSettings;
    private final boolean runtimeMetadata;
    private transient Log log;
    private Settings settings;
    private MetadataExtractor metaExtractor;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static <T> boolean $lessinit$greater$default$2() {
        return EsRDDWriter$.MODULE$.$lessinit$greater$default$2();
    }

    private Log log$lzycompute() {
        EsRDDWriter esRDDWriter = this;
        synchronized (esRDDWriter) {
            if (!this.bitmap$trans$0) {
                this.log = LogFactory.getLog(this.getClass());
                this.bitmap$trans$0 = true;
            }
            return this.log;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Settings settings$lzycompute() {
        EsRDDWriter esRDDWriter = this;
        synchronized (esRDDWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                Settings settings = new PropertiesSettings().load(this.serializedSettings());
                InitializationUtils.setValueWriterIfNotSet(settings, this.valueWriter(), this.log());
                InitializationUtils.setBytesConverterIfNeeded(settings, this.bytesConverter(), this.log());
                InitializationUtils.setFieldExtractorIfNotSet(settings, this.fieldExtractor(), this.log());
                InitializationUtils.setMetadataExtractorIfNotSet(settings, this.metadataExtractor(), this.log());
                InitializationUtils.setUserProviderIfNotSet(settings, this.userProvider(), this.log());
                this.settings = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.settings;
        }
    }

    private MetadataExtractor metaExtractor$lzycompute() {
        EsRDDWriter esRDDWriter = this;
        synchronized (esRDDWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.metaExtractor = (MetadataExtractor)ObjectUtils.instantiate(this.settings().getMappingMetadataExtractorClassName(), this.settings());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.metaExtractor;
        }
    }

    public String serializedSettings() {
        return this.serializedSettings;
    }

    public boolean runtimeMetadata() {
        return this.runtimeMetadata;
    }

    public Log log() {
        return this.bitmap$trans$0 ? this.log : this.log$lzycompute();
    }

    public Settings settings() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.settings$lzycompute() : this.settings;
    }

    public MetadataExtractor metaExtractor() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.metaExtractor$lzycompute() : this.metaExtractor;
    }

    public void write(TaskContext taskContext, Iterator<T> data) {
        RestService.PartitionWriter writer = RestService.createWriter(this.settings(), taskContext.partitionId(), -1, this.log());
        taskContext.addTaskCompletionListener((Function1)((Object)new Serializable(this, writer){
            public static final long serialVersionUID = 0L;
            private final RestService.PartitionWriter writer$1;

            public final void apply(TaskContext TaskContext2) {
                this.writer$1.close();
            }
            {
                this.writer$1 = writer$1;
            }
        }));
        if (this.runtimeMetadata()) {
            writer.repository.addRuntimeFieldExtractor(this.metaExtractor());
        }
        while (data.hasNext()) {
            writer.repository.writeToIndex(this.processData(data));
        }
    }

    public Class<? extends ValueWriter<?>> valueWriter() {
        return ScalaValueWriter.class;
    }

    public Class<? extends BytesConverter> bytesConverter() {
        return JdkBytesConverter.class;
    }

    public Class<? extends FieldExtractor> fieldExtractor() {
        return ScalaMapFieldExtractor.class;
    }

    public Class<? extends MetadataExtractor> metadataExtractor() {
        return ScalaMetadataExtractor.class;
    }

    public Class<? extends UserProvider> userProvider() {
        return HadoopUserProvider.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object processData(Iterator<T> data) {
        Object object;
        T next2 = data.next();
        if (this.runtimeMetadata()) {
            Tuple2 tuple2;
            T t = next2;
            if (!(t instanceof Tuple2)) throw new MatchError(t);
            Tuple2 tuple22 = (Tuple2)t;
            Object key = tuple22._1();
            Object value = tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2(key, value);
            Object key2 = tuple23._1();
            Object value2 = tuple23._2();
            this.metaExtractor().setObject(key2);
            object = value2;
            return object;
        } else {
            object = next2;
        }
        return object;
    }

    public EsRDDWriter(String serializedSettings, boolean runtimeMetadata, ClassTag<T> evidence$1) {
        this.serializedSettings = serializedSettings;
        this.runtimeMetadata = runtimeMetadata;
    }
}

