/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.Random;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.BloomFilter;
import org.apache.hadoop.hbase.util.BloomFilterBase;
import org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hadoop.hbase.util.Hash;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Private
public class ByteBloomFilter
implements BloomFilter,
BloomFilterWriter {
    public static final int VERSION = 1;
    protected long byteSize;
    protected int hashCount;
    protected final int hashType;
    protected final Hash hash;
    protected int keyCount;
    protected int maxKeys;
    protected ByteBuffer bloom;
    public static final String STATS_RECORD_SEP = "; ";
    public static final double LOG2_SQUARED = Math.log(2.0) * Math.log(2.0);
    private static Random randomGeneratorForTest;
    private static final byte[] bitvals;

    public ByteBloomFilter(DataInput meta) throws IOException, IllegalArgumentException {
        this.byteSize = meta.readInt();
        this.hashCount = meta.readInt();
        this.hashType = meta.readInt();
        this.maxKeys = this.keyCount = meta.readInt();
        this.hash = Hash.getInstance(this.hashType);
        if (this.hash == null) {
            throw new IllegalArgumentException("Invalid hash type: " + this.hashType);
        }
        this.sanityCheck();
    }

    public static long computeBitSize(long maxKeys, double errorRate) {
        return (long)Math.ceil((double)maxKeys * (-Math.log(errorRate) / LOG2_SQUARED));
    }

    public static long idealMaxKeys(long bitSize, double errorRate) {
        return (long)((double)bitSize * (LOG2_SQUARED / -Math.log(errorRate)));
    }

    public static long computeMaxKeys(long bitSize, double errorRate, int hashCount) {
        return (long)((double)(-bitSize) * 1.0 / (double)hashCount * Math.log(1.0 - Math.exp(Math.log(errorRate) / (double)hashCount)));
    }

    public double actualErrorRate() {
        return ByteBloomFilter.actualErrorRate(this.keyCount, this.byteSize * 8L, this.hashCount);
    }

    public static double actualErrorRate(long maxKeys, long bitSize, int functionCount) {
        return Math.exp(Math.log(1.0 - Math.exp((double)((long)(-functionCount) * maxKeys) * 1.0 / (double)bitSize)) * (double)functionCount);
    }

    public static int computeFoldableByteSize(long bitSize, int foldFactor) {
        int mask = (1 << foldFactor) - 1;
        long byteSizeLong = (bitSize + 7L) / 8L;
        if (((long)mask & byteSizeLong) != 0L) {
            byteSizeLong >>= foldFactor;
            ++byteSizeLong;
            byteSizeLong <<= foldFactor;
        }
        if (byteSizeLong > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteSize=" + byteSizeLong + " too " + "large for bitSize=" + bitSize + ", foldFactor=" + foldFactor);
        }
        return (int)byteSizeLong;
    }

    private static int optimalFunctionCount(int maxKeys, long bitSize) {
        long i = bitSize / (long)maxKeys;
        double result = Math.ceil(Math.log(2.0) * (double)i);
        if (result > 2.147483647E9) {
            throw new IllegalArgumentException("result too large for integer value.");
        }
        return (int)result;
    }

    private ByteBloomFilter(int hashType) {
        this.hashType = hashType;
        this.hash = Hash.getInstance(hashType);
    }

    public ByteBloomFilter(int maxKeys, double errorRate, int hashType, int foldFactor) throws IllegalArgumentException {
        this(hashType);
        long bitSize = ByteBloomFilter.computeBitSize(maxKeys, errorRate);
        this.hashCount = ByteBloomFilter.optimalFunctionCount(maxKeys, bitSize);
        this.maxKeys = maxKeys;
        this.byteSize = ByteBloomFilter.computeFoldableByteSize(bitSize, foldFactor);
        this.sanityCheck();
    }

    public static ByteBloomFilter createBySize(int byteSizeHint, double errorRate, int hashType, int foldFactor) {
        ByteBloomFilter bbf = new ByteBloomFilter(hashType);
        bbf.byteSize = ByteBloomFilter.computeFoldableByteSize((long)byteSizeHint * 8L, foldFactor);
        long bitSize = bbf.byteSize * 8L;
        bbf.maxKeys = (int)ByteBloomFilter.idealMaxKeys(bitSize, errorRate);
        bbf.hashCount = ByteBloomFilter.optimalFunctionCount(bbf.maxKeys, bitSize);
        bbf.maxKeys = (int)ByteBloomFilter.computeMaxKeys(bitSize, errorRate, bbf.hashCount);
        return bbf;
    }

    public ByteBloomFilter createAnother() {
        ByteBloomFilter bbf = new ByteBloomFilter(this.hashType);
        bbf.byteSize = this.byteSize;
        bbf.hashCount = this.hashCount;
        bbf.maxKeys = this.maxKeys;
        return bbf;
    }

    @Override
    public void allocBloom() {
        if (this.bloom != null) {
            throw new IllegalArgumentException("can only create bloom once.");
        }
        this.bloom = ByteBuffer.allocate((int)this.byteSize);
        assert (this.bloom.hasArray());
    }

    void sanityCheck() throws IllegalArgumentException {
        if (0L >= this.byteSize || this.byteSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid byteSize: " + this.byteSize);
        }
        if (this.hashCount <= 0) {
            throw new IllegalArgumentException("Hash function count must be > 0");
        }
        if (this.hash == null) {
            throw new IllegalArgumentException("hashType must be known");
        }
        if (this.keyCount < 0) {
            throw new IllegalArgumentException("must have positive keyCount");
        }
    }

    void bloomCheck(ByteBuffer bloom) throws IllegalArgumentException {
        if (this.byteSize != (long)bloom.limit()) {
            throw new IllegalArgumentException("Configured bloom length should match actual length");
        }
    }

    public void add(byte[] buf) {
        this.add(buf, 0, buf.length);
    }

    @Override
    public void add(byte[] buf, int offset, int len) {
        int hash1 = this.hash.hash(buf, offset, len, 0);
        int hash2 = this.hash.hash(buf, offset, len, hash1);
        for (int i = 0; i < this.hashCount; ++i) {
            long hashLoc = Math.abs((long)(hash1 + i * hash2) % (this.byteSize * 8L));
            this.set(hashLoc);
        }
        ++this.keyCount;
    }

    boolean contains(byte[] buf) {
        return this.contains(buf, 0, buf.length, this.bloom);
    }

    boolean contains(byte[] buf, int offset, int length) {
        return this.contains(buf, offset, length, this.bloom);
    }

    boolean contains(byte[] buf, ByteBuffer bloom) {
        return this.contains(buf, 0, buf.length, bloom);
    }

    @Override
    public boolean contains(byte[] buf, int offset, int length, ByteBuffer theBloom) {
        if (theBloom == null) {
            theBloom = this.bloom;
        }
        if ((long)theBloom.limit() != this.byteSize) {
            throw new IllegalArgumentException("Bloom does not match expected size: theBloom.limit()=" + theBloom.limit() + ", byteSize=" + this.byteSize);
        }
        return ByteBloomFilter.contains(buf, offset, length, theBloom, 0, (int)this.byteSize, this.hash, this.hashCount);
    }

    public static boolean contains(byte[] buf, int offset, int length, ByteBuffer bloomBuf, int bloomOffset, int bloomSize, Hash hash, int hashCount) {
        int hash1 = hash.hash(buf, offset, length, 0);
        int hash2 = hash.hash(buf, offset, length, hash1);
        int bloomBitSize = bloomSize << 3;
        if (randomGeneratorForTest == null) {
            int compositeHash = hash1;
            for (int i = 0; i < hashCount; ++i) {
                int hashLoc = Math.abs(compositeHash % bloomBitSize);
                compositeHash += hash2;
                if (ByteBloomFilter.get(hashLoc, bloomBuf, bloomOffset)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < hashCount; ++i) {
                int hashLoc = randomGeneratorForTest.nextInt(bloomBitSize);
                if (ByteBloomFilter.get(hashLoc, bloomBuf, bloomOffset)) continue;
                return false;
            }
        }
        return true;
    }

    void set(long pos) {
        int bytePos = (int)(pos / 8L);
        int bitPos = (int)(pos % 8L);
        byte curByte = this.bloom.get(bytePos);
        curByte = (byte)(curByte | bitvals[bitPos]);
        this.bloom.put(bytePos, curByte);
    }

    static boolean get(int pos, ByteBuffer bloomBuf, int bloomOffset) {
        int bytePos = pos >> 3;
        int bitPos = pos & 7;
        byte curByte = bloomBuf.get(bloomOffset + bytePos);
        return (curByte = (byte)(curByte & bitvals[bitPos])) != 0;
    }

    @Override
    public long getKeyCount() {
        return this.keyCount;
    }

    @Override
    public long getMaxKeys() {
        return this.maxKeys;
    }

    @Override
    public long getByteSize() {
        return this.byteSize;
    }

    public int getHashType() {
        return this.hashType;
    }

    @Override
    public void compactBloom() {
        if (this.keyCount > 0 && this.bloom.hasArray()) {
            int newMaxKeys;
            int pieces = 1;
            int newByteSize = (int)this.byteSize;
            for (newMaxKeys = this.maxKeys; (newByteSize & 1) == 0 && newMaxKeys > this.keyCount << 1; newMaxKeys >>= 1) {
                pieces <<= 1;
                newByteSize >>= 1;
            }
            if (pieces > 1) {
                int end;
                byte[] array = this.bloom.array();
                int start = this.bloom.arrayOffset();
                int off = end = start + newByteSize;
                for (int p = 1; p < pieces; ++p) {
                    int pos = start;
                    while (pos < end) {
                        int n = pos++;
                        array[n] = (byte)(array[n] | array[off++]);
                    }
                }
                this.bloom.rewind();
                this.bloom.limit(newByteSize);
                this.bloom = this.bloom.slice();
                this.byteSize = newByteSize;
                this.maxKeys = newMaxKeys;
            }
        }
    }

    public void writeBloom(DataOutput out) throws IOException {
        if (!this.bloom.hasArray()) {
            throw new IOException("Only writes ByteBuffer with underlying array.");
        }
        out.write(this.bloom.array(), this.bloom.arrayOffset(), this.bloom.limit());
    }

    @Override
    public Writable getMetaWriter() {
        return new MetaWriter();
    }

    @Override
    public Writable getDataWriter() {
        return new DataWriter();
    }

    public int getHashCount() {
        return this.hashCount;
    }

    @Override
    public boolean supportsAutoLoading() {
        return this.bloom != null;
    }

    public static void setFakeLookupMode(boolean enabled) {
        randomGeneratorForTest = enabled ? new Random(283742987L) : null;
    }

    @Override
    public byte[] createBloomKey(byte[] rowBuf, int rowOffset, int rowLen, byte[] qualBuf, int qualOffset, int qualLen) {
        if (qualLen <= 0 && rowOffset == 0 && rowLen == rowBuf.length) {
            return rowBuf;
        }
        byte[] result = new byte[rowLen + qualLen];
        System.arraycopy(rowBuf, rowOffset, result, 0, rowLen);
        if (qualLen > 0) {
            System.arraycopy(qualBuf, qualOffset, result, rowLen, qualLen);
        }
        return result;
    }

    @Override
    public KeyValue.KVComparator getComparator() {
        return KeyValue.RAW_COMPARATOR;
    }

    public static String formatStats(BloomFilterBase bloomFilter) {
        StringBuilder sb = new StringBuilder();
        long k = bloomFilter.getKeyCount();
        long m = bloomFilter.getMaxKeys();
        sb.append("BloomSize: " + bloomFilter.getByteSize() + STATS_RECORD_SEP);
        sb.append("No of Keys in bloom: " + k + STATS_RECORD_SEP);
        sb.append("Max Keys for bloom: " + m);
        if (m > 0L) {
            sb.append("; Percentage filled: " + NumberFormat.getPercentInstance().format((double)k * 1.0 / (double)m));
        }
        return sb.toString();
    }

    public String toString() {
        return ByteBloomFilter.formatStats(this) + STATS_RECORD_SEP + "Actual error rate: " + String.format("%.8f", this.actualErrorRate());
    }

    static {
        bitvals = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    }

    private class DataWriter
    implements Writable {
        protected DataWriter() {
        }

        public void readFields(DataInput arg0) throws IOException {
            throw new IOException("Cant read with this class.");
        }

        public void write(DataOutput out) throws IOException {
            ByteBloomFilter.this.writeBloom(out);
        }
    }

    private class MetaWriter
    implements Writable {
        protected MetaWriter() {
        }

        public void readFields(DataInput arg0) throws IOException {
            throw new IOException("Cant read with this class.");
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(1);
            out.writeInt((int)ByteBloomFilter.this.byteSize);
            out.writeInt(ByteBloomFilter.this.hashCount);
            out.writeInt(ByteBloomFilter.this.hashType);
            out.writeInt(ByteBloomFilter.this.keyCount);
        }
    }
}

