/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.callback.HoodieWriteCommitCallback;
import org.apache.hudi.callback.common.HoodieWriteCommitCallbackMessage;
import org.apache.hudi.callback.util.HoodieCommitCallbackFactory;
import org.apache.hudi.client.AbstractHoodieClient;
import org.apache.hudi.client.AsyncCleanerService;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.client.heartbeat.HeartbeatUtils;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.client.utils.TransactionUtils;
import org.apache.hudi.com.codahale.metrics.Timer;
import org.apache.hudi.common.HoodiePendingRollbackInfo;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.TableServiceType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCommitException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieRestoreException;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.exception.HoodieSavepointException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.HoodieTimelineArchiveLog;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.rollback.RollbackUtils;
import org.apache.hudi.table.action.savepoint.SavepointHelpers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractHoodieWriteClient<T extends HoodieRecordPayload, I, K, O>
extends AbstractHoodieClient {
    protected static final String LOOKUP_STR = "lookup";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(AbstractHoodieWriteClient.class);
    protected final transient HoodieMetrics metrics;
    private final transient HoodieIndex<T, ?, ?, ?> index;
    protected transient Timer.Context writeTimer = null;
    protected transient Timer.Context compactionTimer;
    protected transient Timer.Context clusteringTimer;
    private transient WriteOperationType operationType;
    private transient HoodieWriteCommitCallback commitCallback;
    protected transient AsyncCleanerService asyncCleanerService;
    protected final TransactionManager txnManager;
    protected Option<Pair<HoodieInstant, Map<String, String>>> lastCompletedTxnAndMetadata = Option.empty();

    @Deprecated
    public AbstractHoodieWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig) {
        this(context, writeConfig, Option.empty());
    }

    @Deprecated
    public AbstractHoodieWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, Option<EmbeddedTimelineService> timelineService) {
        super(context, writeConfig, timelineService);
        this.metrics = new HoodieMetrics(this.config);
        this.index = this.createIndex(writeConfig);
        this.txnManager = new TransactionManager(this.config, this.fs);
    }

    protected abstract HoodieIndex<T, ?, ?, ?> createIndex(HoodieWriteConfig var1);

    public void setOperationType(WriteOperationType operationType) {
        this.operationType = operationType;
    }

    public WriteOperationType getOperationType() {
        return this.operationType;
    }

    public boolean commit(String instantTime, O writeStatuses) {
        return this.commit(instantTime, writeStatuses, Option.empty());
    }

    public boolean commit(String instantTime, O writeStatuses, Option<Map<String, String>> extraMetadata) {
        HoodieTableMetaClient metaClient = this.createMetaClient(false);
        String actionType = metaClient.getCommitActionType();
        return this.commit(instantTime, writeStatuses, extraMetadata, actionType, Collections.emptyMap());
    }

    public abstract boolean commit(String var1, O var2, Option<Map<String, String>> var3, String var4, Map<String, List<String>> var5);

    public boolean commitStats(String instantTime, List<HoodieWriteStat> stats, Option<Map<String, String>> extraMetadata, String commitActionType) {
        return this.commitStats(instantTime, stats, extraMetadata, commitActionType, Collections.emptyMap());
    }

    public boolean commitStats(String instantTime, List<HoodieWriteStat> stats, Option<Map<String, String>> extraMetadata, String commitActionType, Map<String, List<String>> partitionToReplaceFileIds) {
        if (!this.config.allowEmptyCommit() && stats.isEmpty()) {
            return true;
        }
        LOG.info((Object)("Committing " + instantTime + " action " + commitActionType));
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
        HoodieCommitMetadata metadata = CommitUtils.buildMetadata(stats, partitionToReplaceFileIds, extraMetadata, this.operationType, this.config.getWriteSchema(), commitActionType);
        HoodieInstant inflightInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, table.getMetaClient().getCommitActionType(), instantTime);
        HeartbeatUtils.abortIfHeartbeatExpired(instantTime, table, this.heartbeatClient, this.config);
        this.txnManager.beginTransaction(Option.of(inflightInstant), this.lastCompletedTxnAndMetadata.isPresent() ? Option.of(this.lastCompletedTxnAndMetadata.get().getLeft()) : Option.empty());
        try {
            this.preCommit(inflightInstant, metadata);
            this.commit(table, commitActionType, instantTime, metadata, stats);
            this.postCommit(table, metadata, instantTime, extraMetadata);
            LOG.info((Object)("Committed " + instantTime));
            this.releaseResources();
        }
        catch (IOException e) {
            throw new HoodieCommitException("Failed to complete commit " + this.config.getBasePath() + " at time " + instantTime, e);
        }
        finally {
            this.txnManager.endTransaction();
        }
        this.runTableServicesInline(table, metadata, extraMetadata);
        this.emitCommitMetrics(instantTime, metadata, commitActionType);
        if (this.config.writeCommitCallbackOn()) {
            if (null == this.commitCallback) {
                this.commitCallback = HoodieCommitCallbackFactory.create(this.config);
            }
            this.commitCallback.call(new HoodieWriteCommitCallbackMessage(instantTime, this.config.getTableName(), this.config.getBasePath(), stats));
        }
        return true;
    }

    protected void commit(HoodieTable table, String commitActionType, String instantTime, HoodieCommitMetadata metadata, List<HoodieWriteStat> stats) throws IOException {
        LOG.info((Object)("Committing " + instantTime + " action " + commitActionType));
        HoodieActiveTimeline activeTimeline = table.getActiveTimeline();
        this.finalizeWrite(table, instantTime, stats);
        this.writeTableMetadata(table, instantTime, commitActionType, metadata);
        activeTimeline.saveAsComplete(new HoodieInstant(true, commitActionType, instantTime), Option.of(metadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
    }

    protected HoodieTable<T, I, K, O> createTable(HoodieWriteConfig config, Configuration hadoopConf) {
        return this.createTable(config, hadoopConf, false);
    }

    protected abstract HoodieTable<T, I, K, O> createTable(HoodieWriteConfig var1, Configuration var2, boolean var3);

    void emitCommitMetrics(String instantTime, HoodieCommitMetadata metadata, String actionType) {
        try {
            if (this.writeTimer != null) {
                long durationInMs = this.metrics.getDurationInMs(this.writeTimer.stop());
                this.metrics.updateCommitMetrics(HoodieActiveTimeline.parseDateFromInstantTime(instantTime).getTime(), durationInMs, metadata, actionType);
                this.writeTimer = null;
            }
        }
        catch (ParseException e) {
            throw new HoodieCommitException("Failed to complete commit " + this.config.getBasePath() + " at time " + instantTime + "Instant time is not of valid format", e);
        }
    }

    protected void preCommit(HoodieInstant inflightInstant, HoodieCommitMetadata metadata) {
    }

    protected void writeTableMetadata(HoodieTable table, String instantTime, String actionType, HoodieCommitMetadata metadata) {
        table.getMetadataWriter(instantTime).ifPresent(w -> ((HoodieTableMetadataWriter)w).update(metadata, instantTime, table.isTableServiceAction(actionType)));
    }

    public abstract I filterExists(I var1);

    public void bootstrap(Option<Map<String, String>> extraMetadata) {
        if (this.config.getWriteConcurrencyMode().supportsOptimisticConcurrencyControl()) {
            throw new HoodieException("Cannot bootstrap the table in multi-writer mode");
        }
        HoodieTable<T, I, K, O> table = this.getTableAndInitCtx(WriteOperationType.UPSERT, "00000000000001");
        this.rollbackFailedBootstrap();
        table.bootstrap(this.context, extraMetadata);
    }

    public void rollbackFailedBootstrap() {
        LOG.info((Object)"Rolling back pending bootstrap if present");
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf, this.config.isMetadataTableEnabled());
        HoodieTimeline inflightTimeline = table.getMetaClient().getCommitsTimeline().filterPendingExcludingCompaction();
        Option<String> instant = Option.fromJavaOptional(inflightTimeline.getReverseOrderedInstants().map(HoodieInstant::getTimestamp).findFirst());
        if (instant.isPresent() && HoodieTimeline.compareTimestamps(instant.get(), HoodieTimeline.LESSER_THAN_OR_EQUALS, "00000000000002")) {
            LOG.info((Object)"Found pending bootstrap instants. Rolling them back");
            table.rollbackBootstrap(this.context, HoodieActiveTimeline.createNewInstantTime());
            LOG.info((Object)"Finished rolling back pending bootstrap");
        }
    }

    public abstract O upsert(I var1, String var2);

    public abstract O upsertPreppedRecords(I var1, String var2);

    public abstract O insert(I var1, String var2);

    public abstract O insertPreppedRecords(I var1, String var2);

    public abstract O bulkInsert(I var1, String var2);

    public abstract O bulkInsert(I var1, String var2, Option<BulkInsertPartitioner<I>> var3);

    public abstract O bulkInsertPreppedRecords(I var1, String var2, Option<BulkInsertPartitioner<I>> var3);

    public abstract O delete(K var1, String var2);

    protected void preWrite(String instantTime, WriteOperationType writeOperationType, HoodieTableMetaClient metaClient) {
        this.setOperationType(writeOperationType);
        this.lastCompletedTxnAndMetadata = TransactionUtils.getLastCompletedTxnInstantAndMetadata(metaClient);
        this.asyncCleanerService = AsyncCleanerService.startAsyncCleaningIfEnabled(this);
    }

    protected abstract O postWrite(HoodieWriteMetadata<O> var1, String var2, HoodieTable<T, I, K, O> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postCommit(HoodieTable<T, I, K, O> table, HoodieCommitMetadata metadata, String instantTime, Option<Map<String, String>> extraMetadata) {
        try {
            WriteMarkersFactory.get(this.config.getMarkersType(), table, instantTime).quietDeleteMarkerDir(this.context, this.config.getMarkersDeleteParallelism());
            this.autoCleanOnCommit();
            if (this.config.isAutoArchive()) {
                this.archive(table);
            }
        }
        finally {
            this.heartbeatClient.stop(instantTime);
        }
    }

    protected void runTableServicesInline(HoodieTable<T, I, K, O> table, HoodieCommitMetadata metadata, Option<Map<String, String>> extraMetadata) {
        if (this.config.inlineTableServices().booleanValue()) {
            if (this.config.isMetadataTableEnabled()) {
                table.getHoodieView().sync();
            }
            if (this.config.inlineCompactionEnabled()) {
                this.runAnyPendingCompactions(table);
                metadata.addMetadata(HoodieCompactionConfig.INLINE_COMPACT.key(), "true");
                this.inlineCompact(extraMetadata);
            } else {
                metadata.addMetadata(HoodieCompactionConfig.INLINE_COMPACT.key(), "false");
            }
            if (this.config.inlineClusteringEnabled()) {
                this.runAnyPendingClustering(table);
                metadata.addMetadata(HoodieClusteringConfig.INLINE_CLUSTERING.key(), "true");
                this.inlineCluster(extraMetadata);
            } else {
                metadata.addMetadata(HoodieClusteringConfig.INLINE_CLUSTERING.key(), "false");
            }
        }
    }

    protected void runAnyPendingCompactions(HoodieTable<T, I, K, O> table) {
        table.getActiveTimeline().getWriteTimeline().filterPendingCompactionTimeline().getInstants().forEach(instant -> {
            LOG.info((Object)("Running previously failed inflight compaction at instant " + instant));
            this.compact(instant.getTimestamp(), true);
        });
    }

    protected void runAnyPendingClustering(HoodieTable<T, I, K, O> table) {
        table.getActiveTimeline().filterPendingReplaceTimeline().getInstants().forEach(instant -> {
            Option<Pair<HoodieInstant, HoodieClusteringPlan>> instantPlan = ClusteringUtils.getClusteringPlan(table.getMetaClient(), instant);
            if (instantPlan.isPresent()) {
                LOG.info((Object)("Running pending clustering at instant " + instantPlan.get().getLeft()));
                this.cluster(instant.getTimestamp(), true);
            }
        });
    }

    protected void autoCleanOnCommit() {
        if (this.config.isAutoClean()) {
            if (this.config.isAsyncClean()) {
                LOG.info((Object)"Cleaner has been spawned already. Waiting for it to finish");
                AsyncCleanerService.waitForCompletion(this.asyncCleanerService);
                LOG.info((Object)"Cleaner has finished");
            } else {
                LOG.info((Object)"Auto cleaning is enabled. Running cleaner now");
                this.clean(true);
            }
        }
    }

    public void runAnyPendingCompactions() {
        this.runAnyPendingCompactions(this.createTable(this.config, this.hadoopConf, this.config.isMetadataTableEnabled()));
    }

    public void savepoint(String user, String comment) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf, this.config.isMetadataTableEnabled());
        if (table.getCompletedCommitsTimeline().empty()) {
            throw new HoodieSavepointException("Could not savepoint. Commit timeline is empty");
        }
        String latestCommit = table.getCompletedCommitsTimeline().lastInstant().get().getTimestamp();
        LOG.info((Object)("Savepointing latest commit " + latestCommit));
        this.savepoint(latestCommit, user, comment);
    }

    public void savepoint(String instantTime, String user, String comment) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf, this.config.isMetadataTableEnabled());
        table.savepoint(this.context, instantTime, user, comment);
    }

    public void deleteSavepoint(String savepointTime) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf, this.config.isMetadataTableEnabled());
        SavepointHelpers.deleteSavepoint(table, savepointTime);
    }

    public void restoreToSavepoint(String savepointTime) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf, this.config.isMetadataTableEnabled());
        SavepointHelpers.validateSavepointPresence(table, savepointTime);
        this.restoreToInstant(savepointTime);
        SavepointHelpers.validateSavepointRestore(table, savepointTime);
    }

    @Deprecated
    public boolean rollback(String commitInstantTime) throws HoodieRollbackException {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
        Option<HoodiePendingRollbackInfo> pendingRollbackInfo = this.getPendingRollbackInfo(table.getMetaClient(), commitInstantTime);
        return this.rollback(commitInstantTime, pendingRollbackInfo, false);
    }

    @Deprecated
    public boolean rollback(String commitInstantTime, boolean skipLocking) throws HoodieRollbackException {
        return this.rollback(commitInstantTime, Option.empty(), skipLocking);
    }

    @Deprecated
    public boolean rollback(String commitInstantTime, Option<HoodiePendingRollbackInfo> pendingRollbackInfo, boolean skipLocking) throws HoodieRollbackException {
        LOG.info((Object)("Begin rollback of instant " + commitInstantTime));
        String rollbackInstantTime = pendingRollbackInfo.map(entry -> entry.getRollbackInstant().getTimestamp()).orElse(HoodieActiveTimeline.createNewInstantTime());
        Timer.Context timerContext = this.metrics.getRollbackCtx();
        try {
            HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
            Option<HoodieInstant> commitInstantOpt = Option.fromJavaOptional(table.getActiveTimeline().getCommitsTimeline().getInstants().filter(instant -> HoodieActiveTimeline.EQUALS.test(instant.getTimestamp(), commitInstantTime)).findFirst());
            if (commitInstantOpt.isPresent()) {
                LOG.info((Object)("Scheduling Rollback at instant time :" + rollbackInstantTime));
                Option<HoodieRollbackPlan> rollbackPlanOption = pendingRollbackInfo.map(entry -> Option.of(entry.getRollbackPlan())).orElse(table.scheduleRollback(this.context, rollbackInstantTime, commitInstantOpt.get(), false, this.config.shouldRollbackUsingMarkers()));
                if (rollbackPlanOption.isPresent()) {
                    HoodieRollbackMetadata rollbackMetadata = table.rollback(this.context, rollbackInstantTime, commitInstantOpt.get(), true, skipLocking);
                    if (timerContext != null) {
                        long durationInMs = this.metrics.getDurationInMs(timerContext.stop());
                        this.metrics.updateRollbackMetrics(durationInMs, rollbackMetadata.getTotalFilesDeleted().intValue());
                    }
                    return true;
                }
                throw new HoodieRollbackException("Failed to rollback " + this.config.getBasePath() + " commits " + commitInstantTime);
            }
            LOG.warn((Object)("Cannot find instant " + commitInstantTime + " in the timeline, for rollback"));
            return false;
        }
        catch (Exception e) {
            throw new HoodieRollbackException("Failed to rollback " + this.config.getBasePath() + " commits " + commitInstantTime, e);
        }
    }

    public HoodieRestoreMetadata restoreToInstant(String instantTime) throws HoodieRestoreException {
        LOG.info((Object)("Begin restore to instant " + instantTime));
        String restoreInstantTime = HoodieActiveTimeline.createNewInstantTime();
        Timer.Context timerContext = this.metrics.getRollbackCtx();
        try {
            HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf, this.config.isMetadataTableEnabled());
            HoodieRestoreMetadata restoreMetadata = table.restore(this.context, restoreInstantTime, instantTime);
            if (timerContext != null) {
                long durationInMs = this.metrics.getDurationInMs(timerContext.stop());
                long totalFilesDeleted = restoreMetadata.getHoodieRestoreMetadata().values().stream().flatMap(Collection::stream).mapToLong(HoodieRollbackMetadata::getTotalFilesDeleted).sum();
                this.metrics.updateRollbackMetrics(durationInMs, totalFilesDeleted);
            }
            return restoreMetadata;
        }
        catch (Exception e) {
            throw new HoodieRestoreException("Failed to restore to " + instantTime, e);
        }
    }

    public HoodieCleanMetadata clean(String cleanInstantTime) throws HoodieIOException {
        return this.clean(cleanInstantTime, true, false);
    }

    public HoodieCleanMetadata clean(String cleanInstantTime, boolean skipLocking) throws HoodieIOException {
        return this.clean(cleanInstantTime, true, skipLocking);
    }

    public HoodieCleanMetadata clean(String cleanInstantTime, boolean scheduleInline, boolean skipLocking) throws HoodieIOException {
        if (scheduleInline) {
            this.scheduleTableServiceInternal(cleanInstantTime, Option.empty(), TableServiceType.CLEAN);
        }
        LOG.info((Object)"Cleaner started");
        Timer.Context timerContext = this.metrics.getCleanCtx();
        LOG.info((Object)"Cleaned failed attempts if any");
        CleanerUtils.rollbackFailedWrites(this.config.getFailedWritesCleanPolicy(), "clean", () -> this.rollbackFailedWrites(skipLocking));
        HoodieCleanMetadata metadata = this.createTable(this.config, this.hadoopConf).clean(this.context, cleanInstantTime, skipLocking);
        if (timerContext != null && metadata != null) {
            long durationMs = this.metrics.getDurationInMs(timerContext.stop());
            this.metrics.updateCleanMetrics(durationMs, metadata.getTotalFilesDeleted());
            LOG.info((Object)("Cleaned " + metadata.getTotalFilesDeleted() + " files Earliest Retained Instant :" + metadata.getEarliestCommitToRetain() + " cleanerElapsedMs" + durationMs));
        }
        return metadata;
    }

    public HoodieCleanMetadata clean() {
        return this.clean(false);
    }

    public HoodieCleanMetadata clean(boolean skipLocking) {
        return this.clean(HoodieActiveTimeline.createNewInstantTime(), skipLocking);
    }

    protected void archive(HoodieTable<T, I, K, O> table) {
        try {
            HoodieTimelineArchiveLog<T, I, K, O> archiveLog = new HoodieTimelineArchiveLog<T, I, K, O>(this.config, table);
            archiveLog.archiveIfRequired(this.context);
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Failed to archive", ioe);
        }
    }

    public void archive() {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
        this.archive(table);
    }

    public String startCommit() {
        CleanerUtils.rollbackFailedWrites(this.config.getFailedWritesCleanPolicy(), "commit", () -> this.rollbackFailedWrites());
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        this.startCommit(instantTime, metaClient.getCommitActionType(), metaClient);
        return instantTime;
    }

    public void startCommitWithTime(String instantTime) {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        this.startCommitWithTime(instantTime, metaClient.getCommitActionType(), metaClient);
    }

    public void startCommitWithTime(String instantTime, String actionType) {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        this.startCommitWithTime(instantTime, actionType, metaClient);
    }

    private void startCommitWithTime(String instantTime, String actionType, HoodieTableMetaClient metaClient) {
        CleanerUtils.rollbackFailedWrites(this.config.getFailedWritesCleanPolicy(), "commit", () -> this.rollbackFailedWrites());
        this.startCommit(instantTime, actionType, metaClient);
    }

    private void startCommit(String instantTime, String actionType, HoodieTableMetaClient metaClient) {
        LOG.info((Object)("Generate a new instant time: " + instantTime + " action: " + actionType));
        metaClient.getActiveTimeline().filterPendingCompactionTimeline().lastInstant().ifPresent(latestPending -> ValidationUtils.checkArgument(HoodieTimeline.compareTimestamps(latestPending.getTimestamp(), HoodieTimeline.LESSER_THAN, instantTime), "Latest pending compaction instant time must be earlier than this instant time. Latest Compaction :" + latestPending + ",  Ingesting at " + instantTime));
        if (this.config.getFailedWritesCleanPolicy().isLazy()) {
            this.heartbeatClient.start(instantTime);
        }
        metaClient.getActiveTimeline().createNewInstant(new HoodieInstant(HoodieInstant.State.REQUESTED, actionType, instantTime));
    }

    public Option<String> scheduleCompaction(Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        return this.scheduleCompactionAtInstant(instantTime, extraMetadata) ? Option.of(instantTime) : Option.empty();
    }

    public boolean scheduleCompactionAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.COMPACT).isPresent();
    }

    public O compact(String compactionInstantTime) {
        return this.compact(compactionInstantTime, this.config.shouldAutoCommit());
    }

    public abstract void commitCompaction(String var1, O var2, Option<Map<String, String>> var3) throws IOException;

    protected abstract void completeCompaction(HoodieCommitMetadata var1, O var2, HoodieTable<T, I, K, O> var3, String var4);

    private HoodieTimeline getInflightTimelineExcludeCompactionAndClustering(HoodieTableMetaClient metaClient) {
        HoodieTimeline inflightTimelineWithReplaceCommit = metaClient.getCommitsTimeline().filterPendingExcludingCompaction();
        HoodieTimeline inflightTimelineExcludeClusteringCommit = inflightTimelineWithReplaceCommit.filter(instant -> {
            if (instant.getAction().equals("replacecommit")) {
                Option<Pair<HoodieInstant, HoodieClusteringPlan>> instantPlan = ClusteringUtils.getClusteringPlan(metaClient, instant);
                return !instantPlan.isPresent();
            }
            return true;
        });
        return inflightTimelineExcludeClusteringCommit;
    }

    private Option<HoodiePendingRollbackInfo> getPendingRollbackInfo(HoodieTableMetaClient metaClient, String commitToRollback) {
        return this.getPendingRollbackInfos(metaClient).getOrDefault(commitToRollback, Option.empty());
    }

    protected Map<String, Option<HoodiePendingRollbackInfo>> getPendingRollbackInfos(HoodieTableMetaClient metaClient) {
        return metaClient.getActiveTimeline().filterPendingRollbackTimeline().getInstants().map(entry -> {
            try {
                HoodieRollbackPlan rollbackPlan = RollbackUtils.getRollbackPlan(metaClient, entry);
                return Pair.of(rollbackPlan.getInstantToRollback().getCommitTime(), Option.of(new HoodiePendingRollbackInfo((HoodieInstant)entry, rollbackPlan)));
            }
            catch (IOException e) {
                throw new HoodieIOException("Fetching rollback plan failed for " + entry, e);
            }
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    public Boolean rollbackFailedWrites() {
        return this.rollbackFailedWrites(false);
    }

    public Boolean rollbackFailedWrites(boolean skipLocking) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
        List<String> instantsToRollback = this.getInstantsToRollback(table.getMetaClient(), this.config.getFailedWritesCleanPolicy(), Option.empty());
        Map<String, Option<HoodiePendingRollbackInfo>> pendingRollbacks = this.getPendingRollbackInfos(table.getMetaClient());
        instantsToRollback.forEach(entry -> pendingRollbacks.putIfAbsent((String)entry, Option.empty()));
        this.rollbackFailedWrites(pendingRollbacks, skipLocking);
        return true;
    }

    protected void rollbackFailedWrites(Map<String, Option<HoodiePendingRollbackInfo>> instantsToRollback, boolean skipLocking) {
        LinkedHashMap reverseSortedRollbackInstants = instantsToRollback.entrySet().stream().sorted((i1, i2) -> ((String)i2.getKey()).compareTo((String)i1.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        for (Map.Entry entry : reverseSortedRollbackInstants.entrySet()) {
            if (HoodieTimeline.compareTimestamps((String)entry.getKey(), HoodieTimeline.LESSER_THAN_OR_EQUALS, "00000000000002")) {
                this.rollbackFailedBootstrap();
                HeartbeatUtils.deleteHeartbeatFile(this.fs, this.basePath, (String)entry.getKey(), this.config);
                break;
            }
            this.rollback((String)entry.getKey(), (Option)entry.getValue(), skipLocking);
            HeartbeatUtils.deleteHeartbeatFile(this.fs, this.basePath, (String)entry.getKey(), this.config);
        }
    }

    protected List<String> getInstantsToRollback(HoodieTableMetaClient metaClient, HoodieFailedWritesCleaningPolicy cleaningPolicy, Option<String> curInstantTime) {
        Stream<HoodieInstant> inflightInstantsStream = this.getInflightTimelineExcludeCompactionAndClustering(metaClient).getReverseOrderedInstants();
        if (cleaningPolicy.isEager()) {
            return inflightInstantsStream.map(HoodieInstant::getTimestamp).filter(entry -> {
                if (curInstantTime.isPresent()) {
                    return !entry.equals(curInstantTime.get());
                }
                return true;
            }).collect(Collectors.toList());
        }
        if (cleaningPolicy.isLazy()) {
            return inflightInstantsStream.filter(instant -> {
                try {
                    return this.heartbeatClient.isHeartbeatExpired(instant.getTimestamp());
                }
                catch (IOException io) {
                    throw new HoodieException("Failed to check heartbeat for instant " + instant, io);
                }
            }).map(HoodieInstant::getTimestamp).collect(Collectors.toList());
        }
        if (cleaningPolicy.isNever()) {
            return Collections.EMPTY_LIST;
        }
        throw new IllegalArgumentException("Invalid Failed Writes Cleaning Policy " + (Object)((Object)this.config.getFailedWritesCleanPolicy()));
    }

    protected abstract O compact(String var1, boolean var2);

    protected Option<String> inlineCompact(Option<Map<String, String>> extraMetadata) {
        Option<String> compactionInstantTimeOpt = this.scheduleCompaction(extraMetadata);
        compactionInstantTimeOpt.ifPresent(compactInstantTime -> this.compact((String)compactInstantTime, true));
        return compactionInstantTimeOpt;
    }

    public Option<String> scheduleClustering(Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        return this.scheduleClusteringAtInstant(instantTime, extraMetadata) ? Option.of(instantTime) : Option.empty();
    }

    public boolean scheduleClusteringAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.CLUSTER).isPresent();
    }

    protected Option<String> scheduleCleaning(Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        return this.scheduleCleaningAtInstant(instantTime, extraMetadata) ? Option.of(instantTime) : Option.empty();
    }

    protected boolean scheduleCleaningAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.CLEAN).isPresent();
    }

    public abstract HoodieWriteMetadata<O> cluster(String var1, boolean var2);

    public Option<String> scheduleTableService(Option<Map<String, String>> extraMetadata, TableServiceType tableServiceType) {
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        return this.scheduleTableService(instantTime, extraMetadata, tableServiceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Option<String> scheduleTableService(String instantTime, Option<Map<String, String>> extraMetadata, TableServiceType tableServiceType) {
        try {
            this.txnManager.beginTransaction(Option.of(new HoodieInstant(HoodieInstant.State.REQUESTED, tableServiceType.getAction(), instantTime)), Option.empty());
            LOG.info((Object)("Scheduling table service " + (Object)((Object)tableServiceType)));
            Option<String> option = this.scheduleTableServiceInternal(instantTime, extraMetadata, tableServiceType);
            return option;
        }
        finally {
            this.txnManager.endTransaction();
        }
    }

    private Option<String> scheduleTableServiceInternal(String instantTime, Option<Map<String, String>> extraMetadata, TableServiceType tableServiceType) {
        switch (tableServiceType) {
            case CLUSTER: {
                LOG.info((Object)("Scheduling clustering at instant time :" + instantTime));
                Option<HoodieClusteringPlan> clusteringPlan = this.createTable(this.config, this.hadoopConf, this.config.isMetadataTableEnabled()).scheduleClustering(this.context, instantTime, extraMetadata);
                return clusteringPlan.isPresent() ? Option.of(instantTime) : Option.empty();
            }
            case COMPACT: {
                LOG.info((Object)("Scheduling compaction at instant time :" + instantTime));
                Option<HoodieCompactionPlan> compactionPlan = this.createTable(this.config, this.hadoopConf, this.config.isMetadataTableEnabled()).scheduleCompaction(this.context, instantTime, extraMetadata);
                return compactionPlan.isPresent() ? Option.of(instantTime) : Option.empty();
            }
            case CLEAN: {
                LOG.info((Object)("Scheduling cleaning at instant time :" + instantTime));
                Option<HoodieCleanerPlan> cleanerPlan = this.createTable(this.config, this.hadoopConf, this.config.isMetadataTableEnabled()).scheduleCleaning(this.context, instantTime, extraMetadata);
                return cleanerPlan.isPresent() ? Option.of(instantTime) : Option.empty();
            }
        }
        throw new IllegalArgumentException("Invalid TableService " + (Object)((Object)tableServiceType));
    }

    protected Option<String> inlineCluster(Option<Map<String, String>> extraMetadata) {
        Option<String> clusteringInstantOpt = this.scheduleClustering(extraMetadata);
        clusteringInstantOpt.ifPresent(clusteringInstant -> this.cluster((String)clusteringInstant, true));
        return clusteringInstantOpt;
    }

    protected void rollbackInflightClustering(HoodieInstant inflightInstant, HoodieTable<T, I, K, O> table) {
        String commitTime = HoodieActiveTimeline.createNewInstantTime();
        table.scheduleRollback(this.context, commitTime, inflightInstant, false, this.config.shouldRollbackUsingMarkers());
        table.rollback(this.context, commitTime, inflightInstant, false, false);
        table.getActiveTimeline().revertReplaceCommitInflightToRequested(inflightInstant);
    }

    protected void finalizeWrite(HoodieTable<T, I, K, O> table, String instantTime, List<HoodieWriteStat> stats) {
        try {
            Timer.Context finalizeCtx = this.metrics.getFinalizeCtx();
            table.finalizeWrite(this.context, instantTime, stats);
            if (finalizeCtx != null) {
                Option<Long> durationInMs = Option.of(this.metrics.getDurationInMs(finalizeCtx.stop()));
                durationInMs.ifPresent(duration -> {
                    LOG.info((Object)("Finalize write elapsed time (milliseconds): " + duration));
                    this.metrics.updateFinalizeWriteMetrics((long)duration, stats.size());
                });
            }
        }
        catch (HoodieIOException ioe) {
            throw new HoodieCommitException("Failed to complete commit " + instantTime + " due to finalize errors.", ioe);
        }
    }

    public HoodieMetrics getMetrics() {
        return this.metrics;
    }

    public HoodieIndex<T, ?, ?, ?> getIndex() {
        return this.index;
    }

    protected abstract HoodieTable<T, I, K, O> getTableAndInitCtx(WriteOperationType var1, String var2);

    protected void setWriteSchemaForDeletes(HoodieTableMetaClient metaClient) {
        try {
            HoodieCommitMetadata commitMetadata;
            HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
            Option<HoodieInstant> lastInstant = activeTimeline.filterCompletedInstants().filter(s -> s.getAction().equals(metaClient.getCommitActionType()) || s.getAction().equals("replacecommit")).lastInstant();
            if (lastInstant.isPresent()) {
                commitMetadata = HoodieCommitMetadata.fromBytes(activeTimeline.getInstantDetails(lastInstant.get()).get(), HoodieCommitMetadata.class);
                if (!commitMetadata.getExtraMetadata().containsKey("schema")) {
                    throw new HoodieIOException("Latest commit does not have any schema in commit metadata");
                }
            } else {
                throw new HoodieIOException("Deletes issued without any prior commits");
            }
            this.config.setSchema(commitMetadata.getExtraMetadata().get("schema"));
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException thrown while reading last commit metadata", e);
        }
    }

    protected void releaseResources() {
    }

    @Override
    public void close() {
        AsyncCleanerService.forceShutdown(this.asyncCleanerService);
        this.asyncCleanerService = null;
        super.close();
        this.index.close();
        this.heartbeatClient.stop();
        this.txnManager.close();
    }
}

