/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.run.strategy;

import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.clustering.run.strategy.MultipleSparkJobExecutionStrategy;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.config.HoodieStorageConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.CreateHandleFactory;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.SparkBulkInsertHelper;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;

public class SparkSortAndSizeExecutionStrategy<T extends HoodieRecordPayload<T>>
extends MultipleSparkJobExecutionStrategy<T> {
    private static final Logger LOG = LogManager.getLogger(SparkSortAndSizeExecutionStrategy.class);

    public SparkSortAndSizeExecutionStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    @Override
    public JavaRDD<WriteStatus> performClusteringWithRecordsRDD(JavaRDD<HoodieRecord<T>> inputRecords, int numOutputGroups, String instantTime, Map<String, String> strategyParams, Schema schema2, List<HoodieFileGroupId> fileGroupIdList, boolean preserveHoodieMetadata) {
        LOG.info((Object)("Starting clustering for a group, parallelism:" + numOutputGroups + " commit:" + instantTime));
        TypedProperties props = this.getWriteConfig().getProps();
        props.put(HoodieWriteConfig.BULKINSERT_PARALLELISM_VALUE.key(), String.valueOf(numOutputGroups));
        props.put(HoodieWriteConfig.AUTO_COMMIT_ENABLE.key(), Boolean.FALSE.toString());
        props.put(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE.key(), String.valueOf(this.getWriteConfig().getClusteringTargetFileMaxBytes()));
        HoodieWriteConfig newConfig = HoodieWriteConfig.newBuilder().withProps(props).build();
        return SparkBulkInsertHelper.newInstance().bulkInsert(inputRecords, instantTime, this.getHoodieTable(), newConfig, false, this.getPartitioner(strategyParams, schema2), true, numOutputGroups, (WriteHandleFactory)new CreateHandleFactory(preserveHoodieMetadata));
    }
}

