/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.SparkAdapterSupport$class;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.package$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.AliasIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.MergeIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;

public final class HoodieSqlUtils$
implements SparkAdapterSupport {
    public static final HoodieSqlUtils$ MODULE$;
    private final ThreadLocal<SimpleDateFormat> defaultDateFormat;
    private Set<String> metaFields;
    private final SparkAdapter sparkAdapter;
    private volatile byte bitmap$0;

    static {
        new HoodieSqlUtils$();
    }

    private Set metaFields$lzycompute() {
        HoodieSqlUtils$ hoodieSqlUtils$ = this;
        synchronized (hoodieSqlUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.metaFields = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).toSet();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.metaFields;
        }
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieSqlUtils$ hoodieSqlUtils$ = this;
        synchronized (hoodieSqlUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sparkAdapter = SparkAdapterSupport$class.sparkAdapter(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.sparkAdapter;
        }
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    private ThreadLocal<SimpleDateFormat> defaultDateFormat() {
        return this.defaultDateFormat;
    }

    public boolean isHoodieTable(CatalogTable table) {
        Object object = table.provider().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return x$1.toLowerCase(Locale.ROOT);
            }
        }).orNull(Predef$.MODULE$.$conforms());
        String string = "hudi";
        return !(object != null ? !object.equals(string) : string != null);
    }

    public boolean isHoodieTable(TableIdentifier tableId, SparkSession spark) {
        CatalogTable table = spark.sessionState().catalog().getTableMetadata(tableId);
        return this.isHoodieTable(table);
    }

    public boolean isHoodieTable(LogicalPlan table, SparkSession spark) {
        boolean bl;
        LogicalRelation logicalRelation;
        Option option;
        LogicalPlan logicalPlan = this.tripAlias(table);
        if (logicalPlan instanceof LogicalRelation && (option = (logicalRelation = (LogicalRelation)logicalPlan).catalogTable()) instanceof Some) {
            Some some = (Some)option;
            CatalogTable tbl = (CatalogTable)some.x();
            bl = this.isHoodieTable(tbl);
        } else if (logicalPlan instanceof UnresolvedRelation) {
            UnresolvedRelation unresolvedRelation = (UnresolvedRelation)logicalPlan;
            bl = this.isHoodieTable(this.sparkAdapter().toTableIdentify(unresolvedRelation), spark);
        } else {
            bl = false;
        }
        return bl;
    }

    public TableIdentifier getTableIdentify(LogicalPlan table) {
        LogicalPlan logicalPlan = table;
        if (logicalPlan instanceof SubqueryAlias) {
            SubqueryAlias subqueryAlias = (SubqueryAlias)logicalPlan;
            AliasIdentifier name = subqueryAlias.name();
            TableIdentifier tableIdentifier = this.sparkAdapter().toTableIdentify(name);
            return tableIdentifier;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal table: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})));
    }

    public Option<StructType> getTableSqlSchema(HoodieTableMetaClient metaClient, boolean includeMetadataFields) {
        Some some;
        TableSchemaResolver schemaResolver = new TableSchemaResolver(metaClient);
        try {
            some = new Some((Object)schemaResolver.getTableAvroSchema(includeMetadataFields));
        }
        catch (Throwable throwable) {
            some = None$.MODULE$;
        }
        Some avroSchema = some;
        return avroSchema.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructType apply(Schema avroSchema) {
                return AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(avroSchema);
            }
        });
    }

    public boolean getTableSqlSchema$default$2() {
        return false;
    }

    public Seq<String> getAllPartitionPaths(SparkSession spark, CatalogTable table) {
        HoodieSparkEngineContext sparkEngine = new HoodieSparkEngineContext(new JavaSparkContext(spark.sparkContext()));
        Properties properties = new Properties();
        properties.putAll((java.util.Map<?, ?>)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)spark.sessionState().conf().getAllConfs().$plus$plus((GenTraversableOnce)table.storage().properties()).$plus$plus((GenTraversableOnce)table.properties())).asJava()));
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties(properties).build();
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(FSUtils.getAllPartitionPaths(sparkEngine, metadataConfig, this.getTableLocation(table, spark))).asScala();
    }

    public boolean isHiveStyledPartitioning(Seq<String> partitionPaths, CatalogTable table) {
        boolean bl;
        if (table.partitionColumnNames().nonEmpty()) {
            Serializable isHiveStylePartitionPath = new Serializable(table){
                public static final long serialVersionUID = 0L;
                private final CatalogTable table$2;

                public final boolean apply(String path) {
                    String[] fragments = path.split("/");
                    return Predef$.MODULE$.refArrayOps((Object[])fragments).size() != this.table$2.partitionColumnNames().size() ? false : Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fragments).zip((GenIterable)this.table$2.partitionColumnNames(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<String, String> x0$1) {
                            Tuple2<String, String> tuple2 = x0$1;
                            if (tuple2 != null) {
                                String pathFragment = (String)tuple2._1();
                                String partitionColumn = (String)tuple2._2();
                                boolean bl = pathFragment.startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "="})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionColumn})));
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                    });
                }
                {
                    this.table$2 = table$2;
                }
            };
            bl = partitionPaths.forall((Function1)isHiveStylePartitionPath);
        } else {
            bl = true;
        }
        return bl;
    }

    public boolean isUrlEncodeEnabled(Seq<String> partitionPaths, CatalogTable table) {
        return table.partitionColumnNames().nonEmpty() ? partitionPaths.forall((Function1)new Serializable(table){
            public static final long serialVersionUID = 0L;
            private final CatalogTable table$3;

            public final boolean apply(String partitionPath) {
                return partitionPath.split("/").length == this.table$3.partitionColumnNames().size();
            }
            {
                this.table$3 = table$3;
            }
        }) : false;
    }

    private LogicalPlan tripAlias(LogicalPlan plan) {
        SubqueryAlias subqueryAlias;
        LogicalPlan relation;
        LogicalPlan logicalPlan;
        while ((logicalPlan = plan) instanceof SubqueryAlias && (relation = (subqueryAlias = (SubqueryAlias)logicalPlan).child()) != null) {
            LogicalPlan logicalPlan2;
            plan = logicalPlan2 = relation;
        }
        LogicalPlan logicalPlan3 = logicalPlan;
        return logicalPlan3;
    }

    public StructType addMetaFields(StructType schema2) {
        Buffer metaFields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala();
        StructField[] dataFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])schema2.fields()).filterNot((Function1)new Serializable(metaFields){
            public static final long serialVersionUID = 0L;
            private final Buffer metaFields$1;

            public final boolean apply(StructField f) {
                return this.metaFields$1.contains((Object)f.name());
            }
            {
                this.metaFields$1 = metaFields$1;
            }
        });
        Buffer fields = ((BufferLike)metaFields.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(String x$2) {
                return new StructField(x$2, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            }
        }, Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])dataFields));
        return StructType$.MODULE$.apply((Seq)fields);
    }

    private Set<String> metaFields() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.metaFields$lzycompute() : this.metaFields;
    }

    public StructType removeMetaFields(StructType schema2) {
        return new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])schema2.fields()).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField f) {
                return HoodieSqlUtils$.MODULE$.isMetaField(f.name());
            }
        }));
    }

    public boolean isMetaField(String name) {
        return this.metaFields().contains((Object)name);
    }

    public Dataset<Row> removeMetaFields(Dataset<Row> df) {
        Seq withoutMetaColumns = (Seq)((TraversableLike)df.logicalPlan().output().filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Attribute attr) {
                return HoodieSqlUtils$.MODULE$.isMetaField(attr.name());
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(Attribute x$3) {
                return new Column((Expression)x$3);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return withoutMetaColumns.length() != df.logicalPlan().output().size() ? df.select(withoutMetaColumns) : df;
    }

    public Seq<Attribute> removeMetaFields(Seq<Attribute> attrs) {
        return (Seq)attrs.filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Attribute attr) {
                return HoodieSqlUtils$.MODULE$.isMetaField(attr.name());
            }
        });
    }

    public String getTableLocation(TableIdentifier tableId, SparkSession spark) {
        CatalogTable table = spark.sessionState().catalog().getTableMetadata(tableId);
        return this.getTableLocation(table, spark);
    }

    public String getTableLocation(CatalogTable table, SparkSession sparkSession) {
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
        Option uri = !(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null) && this.isHoodieTable(table) ? new Some((Object)sparkSession.sessionState().catalog().defaultTablePath(table.identifier())) : table.storage().locationUri();
        Configuration conf = sparkSession.sessionState().newHadoopConf();
        return (String)uri.map((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final String apply(URI x$4) {
                return HoodieSqlUtils$.MODULE$.makePathQualified(x$4, this.conf$1);
            }
            {
                this.conf$1 = conf$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String path) {
                return HoodieSqlUtils$.MODULE$.org$apache$spark$sql$hudi$HoodieSqlUtils$$removePlaceHolder(path);
            }
        }).getOrElse((Function0)new Serializable(table){
            public static final long serialVersionUID = 0L;
            private final CatalogTable table$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing location for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$1.identifier()})));
            }
            {
                this.table$1 = table$1;
            }
        });
    }

    public String org$apache$spark$sql$hudi$HoodieSqlUtils$$removePlaceHolder(String path) {
        return path == null || path.length() == 0 ? path : (path.endsWith("-__PLACEHOLDER__") ? path.substring(0, path.length() - 16) : path);
    }

    public String makePathQualified(URI path, Configuration hadoopConf) {
        Path hadoopPath = new Path(path);
        FileSystem fs = hadoopPath.getFileSystem(hadoopConf);
        return fs.makeQualified(hadoopPath).toUri().toString();
    }

    public boolean tableExistsInPath(String tablePath, Configuration conf) {
        Path basePath = new Path(tablePath);
        FileSystem fs = basePath.getFileSystem(conf);
        Path metaPath = new Path(basePath, ".hoodie");
        return fs.exists(metaPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Expression castIfNeeded(Expression child, DataType dataType, SQLConf conf) {
        Expression expression = child;
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            Object nul = literal.value();
            DataType dataType2 = literal.dataType();
            if (NullType$.MODULE$.equals(dataType2)) {
                return new Literal(nul, dataType);
            }
        }
        DataType dataType3 = child.dataType();
        DataType dataType4 = dataType;
        return !(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null) ? child : new Cast(child, dataType, Option$.MODULE$.apply((Object)conf.sessionLocalTimeZone()));
    }

    public TableIdentifier getMergeIntoTargetTableId(MergeIntoTable mergeInto) {
        LogicalPlan logicalPlan;
        block4: {
            AliasIdentifier aliasIdentifier;
            block3: {
                AliasIdentifier tableId;
                SubqueryAlias subqueryAlias;
                boolean bl;
                block2: {
                    AliasIdentifier tableId2;
                    bl = false;
                    subqueryAlias = null;
                    logicalPlan = mergeInto.targetTable();
                    if (!(logicalPlan instanceof SubqueryAlias)) break block2;
                    bl = true;
                    subqueryAlias = (SubqueryAlias)logicalPlan;
                    LogicalPlan logicalPlan2 = subqueryAlias.child();
                    if (!(logicalPlan2 instanceof SubqueryAlias)) break block2;
                    SubqueryAlias subqueryAlias2 = (SubqueryAlias)logicalPlan2;
                    aliasIdentifier = tableId2 = subqueryAlias2.name();
                    break block3;
                }
                if (!bl) break block4;
                aliasIdentifier = tableId = subqueryAlias.name();
            }
            AliasIdentifier aliaId = aliasIdentifier;
            return this.sparkAdapter().toTableIdentify(aliaId);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal plan ", " in target"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logicalPlan})));
    }

    public Seq<Expression> splitByAnd(Expression expression) {
        Seq seq;
        Expression expression2 = expression;
        if (expression2 instanceof And) {
            And and = (And)expression2;
            Expression left = and.left();
            Expression right = and.right();
            seq = (Seq)this.splitByAnd(left).$plus$plus(this.splitByAnd(right), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{expression2}));
        }
        return seq;
    }

    public scala.collection.immutable.Map<String, String> withSparkConf(SparkSession spark, scala.collection.immutable.Map<String, String> options, scala.collection.immutable.Map<String, String> baseConfig) {
        return baseConfig.$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)DFSPropertiesConfiguration.getGlobalProps()).asScala()).$plus$plus((GenTraversableOnce)spark.sessionState().conf().getAllConfs().$plus$plus(HoodieOptionConfig$.MODULE$.mappingSqlOptionToHoodieParam(options)).filterKeys((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$5) {
                return x$5.startsWith("hoodie.");
            }
        }));
    }

    public scala.collection.immutable.Map<String, String> withSparkConf$default$3(SparkSession spark, scala.collection.immutable.Map<String, String> options) {
        return Map$.MODULE$.empty();
    }

    public boolean isSpark3() {
        return package$.MODULE$.SPARK_VERSION().startsWith("3.");
    }

    public boolean isEnableHive(SparkSession sparkSession) {
        return "hive".equals(sparkSession.sessionState().conf().getConf(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION()));
    }

    public String formatQueryInstant(String queryInstant) {
        block5: {
            String string;
            block3: {
                int instantLength;
                block4: {
                    block2: {
                        instantLength = queryInstant.length();
                        if (instantLength != 19 && instantLength != 23) break block2;
                        string = HoodieInstantTimeGenerator.getInstantForDateString(queryInstant);
                        break block3;
                    }
                    if (instantLength != HoodieInstantTimeGenerator.SECS_INSTANT_ID_LENGTH && instantLength != HoodieInstantTimeGenerator.MILLIS_INSTANT_ID_LENGTH) break block4;
                    HoodieActiveTimeline.parseDateFromInstantTime(queryInstant);
                    string = queryInstant;
                    break block3;
                }
                if (instantLength != 10) break block5;
                string = HoodieActiveTimeline.formatDate(((DateFormat)this.defaultDateFormat().get()).parse(queryInstant));
            }
            return string;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported query instant time format: ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queryInstant}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Supported time format are: 'yyyy-MM-dd: HH:mm:ss.SSS' or 'yyyy-MM-dd' or 'yyyyMMddHHmmssSSS'"})).s((Seq)Nil$.MODULE$)).toString());
    }

    public String formatName(SparkSession sparkSession, String name) {
        return sparkSession.sessionState().conf().caseSensitiveAnalysis() ? name : name.toLowerCase(Locale.ROOT);
    }

    public boolean isEmptyPath(String tablePath, Configuration conf) {
        Path basePath = new Path(tablePath);
        FileSystem fs = basePath.getFileSystem(conf);
        return fs.exists(basePath) ? Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(basePath)).isEmpty() : true;
    }

    private HoodieSqlUtils$() {
        MODULE$ = this;
        SparkAdapterSupport$class.$init$(this);
        this.defaultDateFormat = ThreadLocal.withInitial(new Supplier<SimpleDateFormat>(){

            public SimpleDateFormat get() {
                return new SimpleDateFormat("yyyy-MM-dd");
            }
        });
    }
}

