/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.command.CompactionShowHoodiePathCommand$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\u0001\u0003\u0001>\u0011qdQ8na\u0006\u001cG/[8o'\"|w\u000fS8pI&,\u0007+\u0019;i\u0007>lW.\u00198e\u0015\t\u0019A!A\u0004d_6l\u0017M\u001c3\u000b\u0005\u00151\u0011\u0001\u00025vI&T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\t\u001bC\u001d\u0002\"!\u0005\r\u000e\u0003IQ!a\u0005\u000b\u0002\u000f1|w-[2bY*\u0011QCF\u0001\u0006a2\fgn\u001d\u0006\u0003/\u0019\t\u0001bY1uC2L8\u000f^\u0005\u00033I\u00111\u0002T8hS\u000e\fG\u000e\u00157b]B\u00111dH\u0007\u00029)\u00111!\b\u0006\u0003=\u0019\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005\u0001b\"a\u0004*v]:\f'\r\\3D_6l\u0017M\u001c3\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\u000fA\u0013x\u000eZ;diB\u0011!\u0005K\u0005\u0003S\r\u0012AbU3sS\u0006d\u0017N_1cY\u0016D\u0001b\u000b\u0001\u0003\u0016\u0004%\t\u0001L\u0001\u0005a\u0006$\b.F\u0001.!\tq\u0013G\u0004\u0002#_%\u0011\u0001gI\u0001\u0007!J,G-\u001a4\n\u0005I\u001a$AB*ue&twM\u0003\u00021G!AQ\u0007\u0001B\tB\u0003%Q&A\u0003qCRD\u0007\u0005\u0003\u00058\u0001\tU\r\u0011\"\u00019\u0003\u0015a\u0017.\\5u+\u0005I\u0004C\u0001\u0012;\u0013\tY4EA\u0002J]RD\u0001\"\u0010\u0001\u0003\u0012\u0003\u0006I!O\u0001\u0007Y&l\u0017\u000e\u001e\u0011\t\u000b}\u0002A\u0011\u0001!\u0002\rqJg.\u001b;?)\r\t5\t\u0012\t\u0003\u0005\u0002i\u0011A\u0001\u0005\u0006Wy\u0002\r!\f\u0005\u0006oy\u0002\r!\u000f\u0005\u0006\r\u0002!\teR\u0001\u0004eVtGC\u0001%Y!\rI\u0015\u000b\u0016\b\u0003\u0015>s!a\u0013(\u000e\u00031S!!\u0014\b\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0013B\u0001)$\u0003\u001d\u0001\u0018mY6bO\u0016L!AU*\u0003\u0007M+\u0017O\u0003\u0002QGA\u0011QKV\u0007\u0002\r%\u0011qK\u0002\u0002\u0004%><\b\"B-F\u0001\u0004Q\u0016\u0001D:qCJ\\7+Z:tS>t\u0007CA+\\\u0013\tafA\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0004_\u0001\t\u0007I\u0011I0\u0002\r=,H\u000f];u+\u0005\u0001\u0007cA%RCB\u0011!-Z\u0007\u0002G*\u0011AMF\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0002gG\nI\u0011\t\u001e;sS\n,H/\u001a\u0005\u0007Q\u0002\u0001\u000b\u0011\u00021\u0002\u000f=,H\u000f];uA!9!\u000eAA\u0001\n\u0003Y\u0017\u0001B2paf$2!\u00117n\u0011\u001dY\u0013\u000e%AA\u00025BqaN5\u0011\u0002\u0003\u0007\u0011\bC\u0004p\u0001E\u0005I\u0011\u00019\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t\u0011O\u000b\u0002.e.\n1\u000f\u0005\u0002us6\tQO\u0003\u0002wo\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003q\u000e\n!\"\u00198o_R\fG/[8o\u0013\tQXOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Dq\u0001 \u0001\u0012\u0002\u0013\u0005Q0\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003yT#!\u000f:\t\u0013\u0005\u0005\u0001!!A\u0005B\u0005\r\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0006A!\u0011qAA\t\u001b\t\tIA\u0003\u0003\u0002\f\u00055\u0011\u0001\u00027b]\u001eT!!a\u0004\u0002\t)\fg/Y\u0005\u0004e\u0005%\u0001\u0002CA\u000b\u0001\u0005\u0005I\u0011\u0001\u001d\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0013\u0005e\u0001!!A\u0005\u0002\u0005m\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003;\t\u0019\u0003E\u0002#\u0003?I1!!\t$\u0005\r\te.\u001f\u0005\n\u0003K\t9\"!AA\u0002e\n1\u0001\u001f\u00132\u0011%\tI\u0003AA\u0001\n\u0003\nY#A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u0003\u0005\u0004\u00020\u0005U\u0012QD\u0007\u0003\u0003cQ1!a\r$\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003o\t\tD\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\tY\u0004AA\u0001\n\u0003\ti$\u0001\u0005dC:,\u0015/^1m)\u0011\ty$!\u0012\u0011\u0007\t\n\t%C\u0002\u0002D\r\u0012qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002&\u0005e\u0012\u0011!a\u0001\u0003;A\u0011\"!\u0013\u0001\u0003\u0003%\t%a\u0013\u0002\r\u0015\fX/\u00197t)\u0011\ty$!\u0014\t\u0015\u0005\u0015\u0012qIA\u0001\u0002\u0004\tibB\u0005\u0002R\t\t\t\u0011#\u0001\u0002T\u0005y2i\\7qC\u000e$\u0018n\u001c8TQ><\bj\\8eS\u0016\u0004\u0016\r\u001e5D_6l\u0017M\u001c3\u0011\u0007\t\u000b)F\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AA,'\u0015\t)&!\u0017(!\u001d\tY&!\u0019.s\u0005k!!!\u0018\u000b\u0007\u0005}3%A\u0004sk:$\u0018.\\3\n\t\u0005\r\u0014Q\f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004bB \u0002V\u0011\u0005\u0011q\r\u000b\u0003\u0003'B!\"a\u001b\u0002V\u0005\u0005IQIA7\u0003!!xn\u0015;sS:<GCAA\u0003\u0011)\t\t(!\u0016\u0002\u0002\u0013\u0005\u00151O\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u0003\u0006U\u0014q\u000f\u0005\u0007W\u0005=\u0004\u0019A\u0017\t\r]\ny\u00071\u0001:\u0011)\tY(!\u0016\u0002\u0002\u0013\u0005\u0015QP\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ty(a#\u0011\u000b\t\n\t)!\"\n\u0007\u0005\r5E\u0001\u0004PaRLwN\u001c\t\u0006E\u0005\u001dU&O\u0005\u0004\u0003\u0013\u001b#A\u0002+va2,'\u0007C\u0005\u0002\u000e\u0006e\u0014\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010\n\u0019\t\u0015\u0005E\u0015QKA\u0001\n\u0013\t\u0019*A\u0006sK\u0006$'+Z:pYZ,GCAAK!\u0011\t9!a&\n\t\u0005e\u0015\u0011\u0002\u0002\u0007\u001f\nTWm\u0019;")
public class CompactionShowHoodiePathCommand
extends LogicalPlan
implements RunnableCommand,
Serializable {
    private final String path;
    private final int limit;
    private final Seq<Attribute> output;
    private final Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<String, Object>> unapply(CompactionShowHoodiePathCommand compactionShowHoodiePathCommand) {
        return CompactionShowHoodiePathCommand$.MODULE$.unapply(compactionShowHoodiePathCommand);
    }

    public static Function1<Tuple2<String, Object>, CompactionShowHoodiePathCommand> tupled() {
        return CompactionShowHoodiePathCommand$.MODULE$.tupled();
    }

    public static Function1<String, Function1<Object, CompactionShowHoodiePathCommand>> curried() {
        return CompactionShowHoodiePathCommand$.MODULE$.curried();
    }

    private Map metrics$lzycompute() {
        CompactionShowHoodiePathCommand compactionShowHoodiePathCommand = this;
        synchronized (compactionShowHoodiePathCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.class.metrics((RunnableCommand)this);
                this.bitmap$0 = true;
            }
            return this.metrics;
        }
    }

    public Map<String, SQLMetric> metrics() {
        return this.bitmap$0 ? this.metrics : this.metrics$lzycompute();
    }

    public Seq<LogicalPlan> children() {
        return Command.class.children((Command)this);
    }

    public String path() {
        return this.path;
    }

    public int limit() {
        return this.limit;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(this.path().toString()).setConf(sparkSession.sessionState().newHadoopConf()).build();
        HoodieTableType hoodieTableType = metaClient.getTableType();
        HoodieTableType hoodieTableType2 = HoodieTableType.MERGE_ON_READ;
        Predef$.MODULE$.assert(!(hoodieTableType != null ? !((Object)((Object)hoodieTableType)).equals((Object)hoodieTableType2) : hoodieTableType2 != null), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot show compaction on a Non Merge On Read table."})).s((Seq)Nil$.MODULE$);
            }
        });
        HoodieActiveTimeline timeLine = metaClient.getActiveTimeline();
        Seq compactionInstants = (Seq)((IterableLike)((SeqLike)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(timeLine.getInstants().iterator()).asScala()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(HoodieInstant p) {
                String string = p.getAction();
                String string2 = "compaction";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(HoodieInstant f) {
                return f.getTimestamp();
            }
        }, (Ordering)Ordering.String$.MODULE$)).reverse()).take(this.limit());
        Seq compactionPlans = (Seq)compactionInstants.map((Function1)new Serializable(this, metaClient){
            public static final long serialVersionUID = 0L;
            private final HoodieTableMetaClient metaClient$1;

            public final Tuple2<HoodieInstant, HoodieCompactionPlan> apply(HoodieInstant instant) {
                return new Tuple2((Object)instant, (Object)((Object)CompactionUtils.getCompactionPlan(this.metaClient$1, instant.getTimestamp())));
            }
            {
                this.metaClient$1 = metaClient$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (Seq)compactionPlans.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Tuple2<HoodieInstant, HoodieCompactionPlan> x0$1) {
                Tuple2<HoodieInstant, HoodieCompactionPlan> tuple2 = x0$1;
                if (tuple2 != null) {
                    HoodieInstant instant = (HoodieInstant)tuple2._1();
                    HoodieCompactionPlan plan = (HoodieCompactionPlan)((Object)tuple2._2());
                    Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{instant.getTimestamp(), instant.getAction(), BoxesRunTime.boxToInteger((int)plan.getOperations().size())}));
                    return row;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    public CompactionShowHoodiePathCommand copy(String path, int limit) {
        return new CompactionShowHoodiePathCommand(path, limit);
    }

    public String copy$default$1() {
        return this.path();
    }

    public int copy$default$2() {
        return this.limit();
    }

    public String productPrefix() {
        return "CompactionShowHoodiePathCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.limit());
                break;
            }
            case 0: {
                object = this.path();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CompactionShowHoodiePathCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CompactionShowHoodiePathCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        CompactionShowHoodiePathCommand compactionShowHoodiePathCommand = (CompactionShowHoodiePathCommand)((Object)x$1);
        String string = this.path();
        String string2 = compactionShowHoodiePathCommand.path();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.limit() != compactionShowHoodiePathCommand.limit()) return false;
        if (!compactionShowHoodiePathCommand.canEqual((Object)this)) return false;
        return true;
    }

    public CompactionShowHoodiePathCommand(String path, int limit) {
        this.path = path;
        this.limit = limit;
        Command.class.$init$((Command)this);
        RunnableCommand.class.$init$((RunnableCommand)this);
        AttributeReference[] attributeReferenceArray = new AttributeReference[3];
        String x$1 = "timestamp";
        StringType$ x$2 = StringType$.MODULE$;
        boolean x$3 = false;
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
        attributeReferenceArray[0] = new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6);
        String x$7 = "action";
        StringType$ x$8 = StringType$.MODULE$;
        boolean x$9 = false;
        Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$11 = AttributeReference$.MODULE$.apply$default$5(x$7, (DataType)x$8, x$9, x$10);
        Seq x$12 = AttributeReference$.MODULE$.apply$default$6(x$7, (DataType)x$8, x$9, x$10);
        attributeReferenceArray[1] = new AttributeReference(x$7, (DataType)x$8, x$9, x$10, x$11, x$12);
        String x$13 = "size";
        IntegerType$ x$14 = IntegerType$.MODULE$;
        boolean x$15 = false;
        Metadata x$16 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$17 = AttributeReference$.MODULE$.apply$default$5(x$13, (DataType)x$14, x$15, x$16);
        Seq x$18 = AttributeReference$.MODULE$.apply$default$6(x$13, (DataType)x$14, x$15, x$16);
        attributeReferenceArray[2] = new AttributeReference(x$13, (DataType)x$14, x$15, x$16, x$17, x$18);
        this.output = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])attributeReferenceArray));
    }
}

