/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc2;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.TimeZone;
import org.apache.spark.Partition;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.jdbc2.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc2.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc2.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc2.JDBCPartitioningInfo;
import org.apache.spark.sql.execution.datasources.jdbc2.JDBCRDD$;
import org.apache.spark.sql.execution.datasources.jdbc2.JDBCRelation;
import org.apache.spark.sql.execution.datasources.jdbc2.JdbcUtils$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class JDBCRelation$
implements Logging,
Serializable {
    public static final JDBCRelation$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new JDBCRelation$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Partition[] columnPartition(StructType schema, Function2<String, String, Object> resolver, String timeZoneId, JDBCOptions jdbcOptions) {
        Tuple2<String, DataType> tuple2;
        block10: {
            Partition[] partitionArray;
            JDBCPartitioningInfo partitioning;
            block9: {
                Tuple2 tuple22;
                JDBCPartitioningInfo jDBCPartitioningInfo;
                Option<Object> numPartitions;
                Option<String> upperBound;
                Option<String> lowerBound;
                Option<String> partitionColumn;
                block8: {
                    partitionColumn = jdbcOptions.partitionColumn();
                    lowerBound = jdbcOptions.lowerBound();
                    upperBound = jdbcOptions.upperBound();
                    numPartitions = jdbcOptions.numPartitions();
                    if (!partitionColumn.isEmpty()) break block8;
                    Predef$.MODULE$.assert(lowerBound.isEmpty() && upperBound.isEmpty(), (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringBuilder().append((Object)"When 'partitionColumn' is not ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"specified, '", "' and '", "' are expected to be empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JDBCOptions$.MODULE$.JDBC_LOWER_BOUND(), JDBCOptions$.MODULE$.JDBC_UPPER_BOUND()}))).toString();
                        }
                    });
                    jDBCPartitioningInfo = null;
                    break block9;
                }
                Predef$.MODULE$.assert(lowerBound.nonEmpty() && upperBound.nonEmpty() && numPartitions.nonEmpty(), (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"When 'partitionColumn' is specified, '", "', '", "', and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JDBCOptions$.MODULE$.JDBC_LOWER_BOUND(), JDBCOptions$.MODULE$.JDBC_UPPER_BOUND()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' are also required"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JDBCOptions$.MODULE$.JDBC_NUM_PARTITIONS()}))).toString();
                    }
                });
                tuple2 = this.verifyAndGetNormalizedPartitionColumn(schema, (String)partitionColumn.get(), resolver, jdbcOptions);
                if (tuple2 == null) break block10;
                String column = (String)tuple2._1();
                DataType columnType = (DataType)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)column, (Object)columnType);
                String column2 = (String)tuple23._1();
                DataType columnType2 = (DataType)tuple23._2();
                long lowerBoundValue = this.toInternalBoundValue((String)lowerBound.get(), columnType2);
                long upperBoundValue = this.toInternalBoundValue((String)upperBound.get(), columnType2);
                jDBCPartitioningInfo = partitioning = new JDBCPartitioningInfo(column2, columnType2, lowerBoundValue, upperBoundValue, BoxesRunTime.unboxToInt((Object)numPartitions.get()));
            }
            if (partitioning == null || partitioning.numPartitions() <= 1 || partitioning.lowerBound() == partitioning.upperBound()) {
                partitionArray = (Partition[])((Object[])new Partition[]{new JDBCPartition(null, 0)});
            } else {
                long l;
                long upperBound;
                long lowerBound = partitioning.lowerBound();
                Predef$.MODULE$.require(lowerBound <= (upperBound = partitioning.upperBound()), (Function0)new Serializable(lowerBound, upperBound){
                    public static final long serialVersionUID = 0L;
                    private final long lowerBound$1;
                    private final long upperBound$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Operation not allowed: the lower bound of partitioning column is larger than the upper ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bound. Lower bound: ", "; Upper bound: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.lowerBound$1), BoxesRunTime.boxToLong((long)this.upperBound$1)}))).toString();
                    }
                    {
                        this.lowerBound$1 = lowerBound$1;
                        this.upperBound$1 = upperBound$1;
                    }
                });
                Serializable boundValueToString = new Serializable(timeZoneId, partitioning){
                    public static final long serialVersionUID = 0L;
                    private final String timeZoneId$1;
                    private final JDBCPartitioningInfo partitioning$1;

                    public final String apply(long x$2) {
                        return JDBCRelation$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc2$JDBCRelation$$toBoundValueInWhereClause(x$2, this.partitioning$1.columnType(), this.timeZoneId$1);
                    }
                    {
                        this.timeZoneId$1 = timeZoneId$1;
                        this.partitioning$1 = partitioning$1;
                    }
                };
                if (upperBound - lowerBound >= (long)partitioning.numPartitions() || upperBound - lowerBound < 0L) {
                    l = partitioning.numPartitions();
                } else {
                    this.logWarning((Function0<String>)new Serializable(partitioning, lowerBound, upperBound, (Function1)boundValueToString){
                        public static final long serialVersionUID = 0L;
                        private final JDBCPartitioningInfo partitioning$1;
                        private final long lowerBound$1;
                        private final long upperBound$1;
                        private final Function1 boundValueToString$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"The number of partitions is reduced because the specified number of partitions is less than the difference between upper bound and lower bound. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated number of partitions: ", "; Input number of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.upperBound$1 - this.lowerBound$1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitions: ", "; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.partitioning$1.numPartitions())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Lower bound: ", "; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.boundValueToString$1.apply((Object)BoxesRunTime.boxToLong((long)this.lowerBound$1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Upper bound: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.boundValueToString$1.apply((Object)BoxesRunTime.boxToLong((long)this.upperBound$1))}))).toString();
                        }
                        {
                            this.partitioning$1 = partitioning$1;
                            this.lowerBound$1 = lowerBound$1;
                            this.upperBound$1 = upperBound$1;
                            this.boundValueToString$1 = boundValueToString$1;
                        }
                    });
                    l = upperBound - lowerBound;
                }
                long numPartitions = l;
                long stride = upperBound / numPartitions - lowerBound / numPartitions;
                int i = 0;
                String column = partitioning.column();
                long currentValue = lowerBound;
                ArrayBuffer ans = new ArrayBuffer();
                while ((long)i < numPartitions) {
                    String uBound;
                    String lBoundValue = (String)boundValueToString.apply((Object)BoxesRunTime.boxToLong((long)currentValue));
                    String lBound = i != 0 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " >= ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{column, lBoundValue})) : null;
                    String uBoundValue = (String)boundValueToString.apply((Object)BoxesRunTime.boxToLong((long)(currentValue += stride)));
                    String string = uBound = (long)i != numPartitions - 1L ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " < ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{column, uBoundValue})) : null;
                    String whereClause = uBound == null ? lBound : (lBound == null ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " or ", " is null"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uBound, column})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " AND ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lBound, uBound})));
                    ans.$plus$eq((Object)new JDBCPartition(whereClause, i));
                    ++i;
                }
                Partition[] partitions = (Partition[])ans.toArray(ClassTag$.MODULE$.apply(Partition.class));
                this.logInfo((Function0<String>)new Serializable(numPartitions, partitions){
                    public static final long serialVersionUID = 0L;
                    private final long numPartitions$1;
                    private final Partition[] partitions$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of partitions: ", ", WHERE clauses of these partitions: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.numPartitions$1)}))).append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.partitions$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Partition x$3) {
                                return ((JDBCPartition)x$3).whereClause();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(", ")).toString();
                    }
                    {
                        this.numPartitions$1 = numPartitions$1;
                        this.partitions$1 = partitions$1;
                    }
                });
                partitionArray = partitions;
            }
            return partitionArray;
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<String, DataType> verifyAndGetNormalizedPartitionColumn(StructType schema, String columnName, Function2<String, String, Object> resolver, JDBCOptions jdbcOptions) {
        void var6_6;
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(jdbcOptions.url());
        StructField column = (StructField)schema.find((Function1)new Serializable(columnName, resolver, dialect){
            public static final long serialVersionUID = 0L;
            private final String columnName$1;
            private final Function2 resolver$1;
            private final JdbcDialect dialect$1;

            public final boolean apply(StructField f) {
                return BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)f.name(), (Object)this.columnName$1)) || BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)this.dialect$1.quoteIdentifier(f.name()), (Object)this.columnName$1));
            }
            {
                this.columnName$1 = columnName$1;
                this.resolver$1 = resolver$1;
                this.dialect$1 = dialect$1;
            }
        }).getOrElse((Function0)new Serializable(schema, columnName){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;
            private final String columnName$1;

            public final Nothing$ apply() {
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User-defined partition column ", " not "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.columnName$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"found in the JDBC relation: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.schema$1.simpleString(Utils$.MODULE$.maxNumToStringFields())}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.schema$1 = schema$1;
                this.columnName$1 = columnName$1;
            }
        });
        DataType dataType = column.dataType();
        boolean bl = dataType instanceof NumericType ? true : (DateType$.MODULE$.equals(dataType) ? true : TimestampType$.MODULE$.equals(dataType));
        if (bl) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return new Tuple2((Object)dialect.quoteIdentifier(column.name()), (Object)column.dataType());
        }
        throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition column type should be ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{NumericType$.MODULE$.simpleString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", or ", ", but "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateType$.MODULE$.catalogString(), TimestampType$.MODULE$.catalogString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var6_6.dataType().catalogString()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private long toInternalBoundValue(String value, DataType columnType) {
        DataType dataType;
        block5: {
            long l;
            block3: {
                block4: {
                    block2: {
                        dataType = columnType;
                        if (!(dataType instanceof NumericType)) break block2;
                        l = new StringOps(Predef$.MODULE$.augmentString(value)).toLong();
                        break block3;
                    }
                    if (!DateType$.MODULE$.equals(dataType)) break block4;
                    l = DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf(value));
                    break block3;
                }
                if (!TimestampType$.MODULE$.equals(dataType)) break block5;
                l = DateTimeUtils$.MODULE$.fromJavaTimestamp(Timestamp.valueOf(value));
            }
            return l;
        }
        throw new MatchError((Object)dataType);
    }

    public String org$apache$spark$sql$execution$datasources$jdbc2$JDBCRelation$$toBoundValueInWhereClause(long value, DataType columnType, String timeZoneId) {
        DataType dataType;
        block4: {
            String string;
            block3: {
                block2: {
                    dataType = columnType;
                    if (!(dataType instanceof NumericType)) break block2;
                    string = ((Object)BoxesRunTime.boxToLong((long)value)).toString();
                    break block3;
                }
                boolean bl = DateType$.MODULE$.equals(dataType) ? true : TimestampType$.MODULE$.equals(dataType);
                if (!bl) break block4;
                string = this.dateTimeToString$1(value, columnType, timeZoneId);
            }
            return string;
        }
        throw new MatchError((Object)dataType);
    }

    public StructType getSchema(Function2<String, String, Object> resolver, JDBCOptions jdbcOptions) {
        Option<String> option;
        block4: {
            StructType structType;
            block3: {
                StructType tableSchema;
                block2: {
                    tableSchema = JDBCRDD$.MODULE$.resolveTable(jdbcOptions);
                    option = jdbcOptions.customSchema();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String customSchema = (String)some.x();
                    structType = JdbcUtils$.MODULE$.getCustomSchema(tableSchema, customSchema, resolver);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                structType = tableSchema;
            }
            return structType;
        }
        throw new MatchError(option);
    }

    public JDBCRelation apply(Partition[] parts, JDBCOptions jdbcOptions, SparkSession sparkSession) {
        StructType schema = this.getSchema((Function2<String, String, Object>)sparkSession.sessionState().conf().resolver(), jdbcOptions);
        return new JDBCRelation(schema, parts, jdbcOptions, sparkSession);
    }

    public JDBCRelation apply(StructType schema, Partition[] parts, JDBCOptions jdbcOptions, SparkSession sparkSession) {
        return new JDBCRelation(schema, parts, jdbcOptions, sparkSession);
    }

    public Option<Tuple3<StructType, Partition[], JDBCOptions>> unapply(JDBCRelation x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.schema(), (Object)x$0.parts(), (Object)x$0.jdbcOptions()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final String dateTimeToString$1(long value$1, DataType columnType$1, String timeZoneId$2) {
        DataType dataType;
        block4: {
            String string;
            block3: {
                TimeZone timeZone;
                block2: {
                    timeZone = DateTimeUtils$.MODULE$.getTimeZone(timeZoneId$2);
                    dataType = columnType$1;
                    if (!DateType$.MODULE$.equals(dataType)) break block2;
                    string = DateTimeUtils$.MODULE$.dateToString((int)value$1, timeZone);
                    break block3;
                }
                if (!TimestampType$.MODULE$.equals(dataType)) break block4;
                string = DateTimeUtils$.MODULE$.timestampToString(value$1, timeZone);
            }
            String dateTimeStr = string;
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dateTimeStr}));
        }
        throw new MatchError((Object)dataType);
    }

    private JDBCRelation$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

