/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.e2e.common.container.seatunnel;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.seatunnel.e2e.common.container.AbstractTestContainer;
import org.apache.seatunnel.e2e.common.container.ContainerExtendedFactory;
import org.apache.seatunnel.e2e.common.container.TestContainerId;
import org.apache.seatunnel.e2e.common.util.ContainerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.lifecycle.Startables;
import org.testcontainers.utility.DockerLoggerFactory;
import org.testcontainers.utility.MountableFile;

public class ConnectorPackageServiceContainer
extends AbstractTestContainer {
    private static final Logger log = LoggerFactory.getLogger(ConnectorPackageServiceContainer.class);
    private static final String JDK_DOCKER_IMAGE = "openjdk:8";
    private static final String CLIENT_SHELL = "seatunnel.sh";
    private static final String SERVER_SHELL = "seatunnel-cluster.sh";
    private GenericContainer<?> server1;
    private GenericContainer<?> server2;
    private GenericContainer<?> server3;

    @Override
    public void startUp() throws Exception {
        this.server1 = new GenericContainer(this.getDockerImage()).withNetwork(NETWORK).withCommand(ContainerUtil.adaptPathForWin(Paths.get("/tmp/seatunnel/", "bin", SERVER_SHELL).toString())).withNetworkAliases(new String[]{"server1"}).withExposedPorts(new Integer[0]).withLogConsumer((Consumer)new Slf4jLogConsumer(DockerLoggerFactory.getLogger((String)"seatunnel-engine:openjdk:8"))).waitingFor((WaitStrategy)Wait.forListeningPort());
        this.copySeaTunnelStarterToContainer(this.server1);
        this.server1.setExposedPorts(Arrays.asList(5801));
        this.server1.withCopyFileToContainer(MountableFile.forHostPath((String)(ContainerUtil.PROJECT_ROOT_PATH + "/seatunnel-e2e/seatunnel-engine-e2e/connector-seatunnel-e2e-base/src/test/resources/connector-package-service-test-server1-resources")), Paths.get("/tmp/seatunnel/", "config").toString());
        this.server1.withCopyFileToContainer(MountableFile.forHostPath((String)(ContainerUtil.PROJECT_ROOT_PATH + "/seatunnel-shade/seatunnel-hadoop3-3.1.4-uber/target/seatunnel-hadoop3-3.1.4-uber.jar")), Paths.get("/tmp/seatunnel/", "lib/seatunnel-hadoop3-3.1.4-uber.jar").toString());
        this.server2 = new GenericContainer(this.getDockerImage()).withNetwork(NETWORK).withCommand(ContainerUtil.adaptPathForWin(Paths.get("/tmp/seatunnel/", "bin", SERVER_SHELL).toString())).withNetworkAliases(new String[]{"server2"}).withExposedPorts(new Integer[0]).withLogConsumer((Consumer)new Slf4jLogConsumer(DockerLoggerFactory.getLogger((String)"seatunnel-engine:openjdk:8"))).waitingFor((WaitStrategy)Wait.forListeningPort());
        this.copySeaTunnelStarterToContainer(this.server2);
        this.server2.setExposedPorts(Arrays.asList(5802));
        this.server2.withCopyFileToContainer(MountableFile.forHostPath((String)(ContainerUtil.PROJECT_ROOT_PATH + "/seatunnel-e2e/seatunnel-engine-e2e/connector-seatunnel-e2e-base/src/test/resources/connector-package-service-test-server2-resources")), Paths.get("/tmp/seatunnel/", "config").toString());
        this.server2.withCopyFileToContainer(MountableFile.forHostPath((String)(ContainerUtil.PROJECT_ROOT_PATH + "/seatunnel-shade/seatunnel-hadoop3-3.1.4-uber/target/seatunnel-hadoop3-3.1.4-uber.jar")), Paths.get("/tmp/seatunnel/", "lib/seatunnel-hadoop3-3.1.4-uber.jar").toString());
        this.server3 = new GenericContainer(this.getDockerImage()).withNetwork(NETWORK).withCommand(ContainerUtil.adaptPathForWin(Paths.get("/tmp/seatunnel/", "bin", SERVER_SHELL).toString())).withNetworkAliases(new String[]{"server3"}).withExposedPorts(new Integer[0]).withLogConsumer((Consumer)new Slf4jLogConsumer(DockerLoggerFactory.getLogger((String)"seatunnel-engine:openjdk:8"))).waitingFor((WaitStrategy)Wait.forListeningPort());
        this.copySeaTunnelStarterToContainer(this.server3);
        this.server3.setExposedPorts(Arrays.asList(5803));
        this.server3.withCopyFileToContainer(MountableFile.forHostPath((String)(ContainerUtil.PROJECT_ROOT_PATH + "/seatunnel-e2e/seatunnel-engine-e2e/connector-seatunnel-e2e-base/src/test/resources/connector-package-service-test-server3-resources")), Paths.get("/tmp/seatunnel/", "config").toString());
        this.server3.withCopyFileToContainer(MountableFile.forHostPath((String)(ContainerUtil.PROJECT_ROOT_PATH + "/seatunnel-shade/seatunnel-hadoop3-3.1.4-uber/target/seatunnel-hadoop3-3.1.4-uber.jar")), Paths.get("/tmp/seatunnel/", "lib/seatunnel-hadoop3-3.1.4-uber.jar").toString());
        Startables.deepStart(Stream.of(this.server1)).join();
        Startables.deepStart(Stream.of(this.server2)).join();
        Startables.deepStart(Stream.of(this.server3)).join();
        this.executeExtraCommands(this.server1);
    }

    @Override
    public void tearDown() throws Exception {
        if (this.server1 != null) {
            this.server1.close();
        }
        if (this.server2 != null) {
            this.server2.close();
        }
        if (this.server3 != null) {
            this.server3.close();
        }
    }

    @Override
    protected String getDockerImage() {
        return JDK_DOCKER_IMAGE;
    }

    @Override
    protected String getStartModuleName() {
        return "seatunnel-starter";
    }

    @Override
    protected String getStartShellName() {
        return CLIENT_SHELL;
    }

    @Override
    protected String getConnectorModulePath() {
        return "seatunnel-connectors-v2";
    }

    @Override
    protected String getConnectorType() {
        return "seatunnel";
    }

    @Override
    protected String getSavePointCommand() {
        return "-s";
    }

    @Override
    protected String getCancelJobCommand() {
        return "-can";
    }

    @Override
    protected String getRestoreCommand() {
        return "-r";
    }

    @Override
    protected String getConnectorNamePrefix() {
        return "connector-";
    }

    @Override
    protected List<String> getExtraStartShellCommands() {
        return Collections.emptyList();
    }

    @Override
    public TestContainerId identifier() {
        return TestContainerId.SEATUNNEL;
    }

    @Override
    public void executeExtraCommands(ContainerExtendedFactory extendedFactory) throws IOException, InterruptedException {
        extendedFactory.extend(this.server1);
        extendedFactory.extend(this.server2);
        extendedFactory.extend(this.server3);
    }

    @Override
    public Container.ExecResult executeJob(String confFile) throws IOException, InterruptedException {
        return this.executeJob(confFile, Collections.emptyList());
    }

    @Override
    public Container.ExecResult executeJob(String confFile, List<String> variables) throws IOException, InterruptedException {
        log.info("test in container: {}", (Object)this.identifier());
        return this.executeJob(this.server1, confFile, null, variables);
    }

    @Override
    public String getServerLogs() {
        return this.server1.getLogs();
    }

    @Override
    public void copyFileToContainer(String path, String targetPath) {
        ContainerUtil.copyFileIntoContainers(ContainerUtil.getResourcesFile(path).toPath(), targetPath, this.server1);
    }

    @Override
    public void copyAbsolutePathToContainer(String path, String targetPath) {
        ContainerUtil.copyFileIntoContainers(Paths.get(path, new String[0]), targetPath, this.server1);
    }
}

