/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.e2e.common.junit;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.seatunnel.e2e.common.container.ContainerExtendedFactory;
import org.apache.seatunnel.e2e.common.container.TestContainer;
import org.apache.seatunnel.e2e.common.junit.AnnotationUtil;
import org.apache.seatunnel.e2e.common.junit.ContainerTestingExtension;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCaseInvocationContextProvider
implements TestTemplateInvocationContextProvider {
    private static final Logger log = LoggerFactory.getLogger(TestCaseInvocationContextProvider.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean supportsTestTemplate(ExtensionContext context) {
        Class<?>[] parameterTypes = context.getRequiredTestMethod().getParameterTypes();
        if (parameterTypes.length != 1) return false;
        if (!Arrays.stream(parameterTypes).anyMatch(TestContainer.class::isAssignableFrom)) return false;
        return true;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        List<TestContainer> testContainers = AnnotationUtil.filterDisabledContainers((List)context.getStore(ContainerTestingExtension.TEST_RESOURCE_NAMESPACE).get((Object)"testContainers"), context.getRequiredTestMethod());
        ContainerExtendedFactory containerExtendedFactory = (ContainerExtendedFactory)context.getStore(ContainerTestingExtension.TEST_RESOURCE_NAMESPACE).get((Object)"testContainerExtendedFactory");
        int containerAmount = testContainers.size();
        return testContainers.stream().map(testContainer -> new TestResourceProvidingInvocationContext((TestContainer)testContainer, containerExtendedFactory, containerAmount));
    }

    private static class TestContainerResolver
    implements ParameterResolver {
        private final TestContainer testContainer;
        private final ContainerExtendedFactory containerExtendedFactory;

        private TestContainerResolver(TestContainer testContainer, ContainerExtendedFactory containerExtendedFactory) {
            this.testContainer = testContainer;
            this.containerExtendedFactory = containerExtendedFactory;
        }

        public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            return TestContainer.class.isAssignableFrom(parameterContext.getParameter().getType());
        }

        public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            this.testContainer.startUp();
            this.testContainer.executeExtraCommands(this.containerExtendedFactory);
            log.info("The TestContainer[{}] is running.", (Object)this.testContainer.identifier());
            return this.testContainer;
        }
    }

    static class TestResourceProvidingInvocationContext
    implements TestTemplateInvocationContext {
        private final TestContainer testContainer;
        private final ContainerExtendedFactory containerExtendedFactory;
        private final Integer containerAmount;

        public TestResourceProvidingInvocationContext(TestContainer testContainer, ContainerExtendedFactory containerExtendedFactory, int containerAmount) {
            this.testContainer = testContainer;
            this.containerExtendedFactory = containerExtendedFactory;
            this.containerAmount = containerAmount;
        }

        public String getDisplayName(int invocationIndex) {
            return String.format("TestContainer(%s/%s): %s", new Object[]{invocationIndex, this.containerAmount, this.testContainer.identifier()});
        }

        public List<Extension> getAdditionalExtensions() {
            return Arrays.asList(new TestContainerResolver(this.testContainer, this.containerExtendedFactory), ignore -> {
                this.testContainer.tearDown();
                log.info("The TestContainer[{}] is closed.", (Object)this.testContainer.identifier());
            });
        }
    }
}

