/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.e2e.common.junit;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLoggerExtension
implements TestWatcher,
BeforeEachCallback {
    private static final Logger LOG = LoggerFactory.getLogger(TestLoggerExtension.class);

    public void beforeEach(ExtensionContext context) {
        LOG.info("\n================================================================================\nTest {}.{} is running.\n--------------------------------------------------------------------------------", (Object)context.getRequiredTestClass().getCanonicalName(), (Object)context.getRequiredTestMethod().getName());
    }

    public void testSuccessful(ExtensionContext context) {
        LOG.info("\n--------------------------------------------------------------------------------\nTest {}.{} successfully run.\n================================================================================", (Object)context.getRequiredTestClass().getCanonicalName(), (Object)context.getRequiredTestMethod().getName());
    }

    public void testFailed(ExtensionContext context, Throwable cause) {
        LOG.error("\n--------------------------------------------------------------------------------\nTest {}.{} failed with:\n{}\n================================================================================", new Object[]{context.getRequiredTestClass().getCanonicalName(), context.getRequiredTestMethod().getName(), TestLoggerExtension.exceptionToString(cause)});
    }

    private static String exceptionToString(Throwable t) {
        if (t == null) {
            return "(null)";
        }
        try {
            StringWriter stm = new StringWriter();
            PrintWriter wrt = new PrintWriter(stm);
            t.printStackTrace(wrt);
            wrt.close();
            return stm.toString();
        }
        catch (Throwable ignored) {
            return t.getClass().getName() + " (error while printing stack trace)";
        }
    }
}

