/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.e2e.common.junit;

import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimingExtension
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private static final Logger LOG = LoggerFactory.getLogger(TimingExtension.class);
    private static final String START_TIME = "start time";

    public void afterTestExecution(ExtensionContext context) throws Exception {
        Class testClass = context.getRequiredTestClass();
        Method testMethod = context.getRequiredTestMethod();
        long startTime = (Long)this.getStore(context).remove((Object)START_TIME, Long.TYPE);
        long duration = System.currentTimeMillis() - startTime;
        LOG.info(" [{}#{}] E2E test case cost {}s.", new Object[]{testClass.getName(), testMethod.getName(), duration / 1000L});
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        this.getStore(context).put((Object)START_TIME, (Object)System.currentTimeMillis());
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context.getRequiredTestMethod()}));
    }
}

