/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.e2e.sink.inmemory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.sink.MultiTableResourceManager;
import org.apache.seatunnel.api.sink.SinkAggregatedCommitter;
import org.apache.seatunnel.api.sink.SupportMultiTableSinkAggregatedCommitter;
import org.apache.seatunnel.e2e.sink.inmemory.InMemoryAggregatedCommitInfo;
import org.apache.seatunnel.e2e.sink.inmemory.InMemoryCommitInfo;
import org.apache.seatunnel.e2e.sink.inmemory.InMemoryConnection;
import org.apache.seatunnel.e2e.sink.inmemory.InMemoryMultiTableResourceManager;
import org.apache.seatunnel.e2e.sink.inmemory.InMemorySinkFactory;

public class InMemoryAggregatedCommitter
implements SinkAggregatedCommitter<InMemoryCommitInfo, InMemoryAggregatedCommitInfo>,
SupportMultiTableSinkAggregatedCommitter<InMemoryConnection> {
    private static final List<String> events = new ArrayList<String>();
    private static final List<InMemoryMultiTableResourceManager> resourceManagers = new ArrayList<InMemoryMultiTableResourceManager>();
    private ReadonlyConfig config;
    private InMemoryMultiTableResourceManager resourceManager;

    public InMemoryAggregatedCommitter(ReadonlyConfig config) {
        this.config = config;
    }

    public static List<String> getEvents() {
        return events;
    }

    public static List<InMemoryMultiTableResourceManager> getResourceManagers() {
        return resourceManagers;
    }

    public MultiTableResourceManager<InMemoryConnection> initMultiTableResourceManager(int tableSize, int queueSize) {
        events.add("initMultiTableResourceManager" + queueSize);
        return new InMemoryMultiTableResourceManager();
    }

    public void setMultiTableResourceManager(MultiTableResourceManager<InMemoryConnection> multiTableResourceManager, int queueIndex) {
        events.add("setMultiTableResourceManager" + queueIndex);
        this.resourceManager = (InMemoryMultiTableResourceManager)multiTableResourceManager;
        resourceManagers.add(this.resourceManager);
    }

    public List<InMemoryAggregatedCommitInfo> commit(List<InMemoryAggregatedCommitInfo> aggregatedCommitInfo) throws IOException {
        if (((Boolean)this.config.get(InMemorySinkFactory.THROW_EXCEPTION_OF_COMMITTER)).booleanValue()) {
            throw new IOException("commit failed");
        }
        return new ArrayList<InMemoryAggregatedCommitInfo>();
    }

    public InMemoryAggregatedCommitInfo combine(List<InMemoryCommitInfo> commitInfos) {
        return new InMemoryAggregatedCommitInfo();
    }

    public void abort(List<InMemoryAggregatedCommitInfo> aggregatedCommitInfo) throws Exception {
    }

    public void close() throws IOException {
    }
}

