/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.e2e.sink.inmemory;

import java.util.List;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.SaveModeHandler;
import org.apache.seatunnel.api.sink.SchemaSaveMode;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemorySaveModeHandler
implements SaveModeHandler {
    private static final Logger log = LoggerFactory.getLogger(InMemorySaveModeHandler.class);
    private final CatalogTable catalogTable;

    public InMemorySaveModeHandler(CatalogTable catalogTable) {
        this.catalogTable = catalogTable;
    }

    public void open() {
    }

    public void handleSchemaSaveMode() {
        log.info("handle schema savemode with table path: {}", (Object)this.catalogTable.getTablePath());
    }

    public void handleDataSaveMode() {
        log.info("handle data savemode with table path: {}", (Object)this.catalogTable.getTablePath());
    }

    public void handleSchemaSaveModeWithRestore() {
    }

    public SchemaSaveMode getSchemaSaveMode() {
        return SchemaSaveMode.CREATE_SCHEMA_WHEN_NOT_EXIST;
    }

    public DataSaveMode getDataSaveMode() {
        return DataSaveMode.APPEND_DATA;
    }

    public TablePath getHandleTablePath() {
        return this.catalogTable.getTablePath();
    }

    public Catalog getHandleCatalog() {
        return new Catalog(){

            public void open() throws CatalogException {
            }

            public void close() throws CatalogException {
            }

            public String name() {
                return "InMemoryCatalog";
            }

            public String getDefaultDatabase() throws CatalogException {
                return null;
            }

            public boolean databaseExists(String databaseName) throws CatalogException {
                return false;
            }

            public List<String> listDatabases() throws CatalogException {
                return null;
            }

            public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
                return null;
            }

            public boolean tableExists(TablePath tablePath) throws CatalogException {
                return false;
            }

            public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
                return null;
            }

            public void createTable(TablePath tablePath, CatalogTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
            }

            public void dropTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
            }

            public void createDatabase(TablePath tablePath, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
            }

            public void dropDatabase(TablePath tablePath, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
            }
        };
    }

    public void close() throws Exception {
    }
}

