/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.e2e.sink.inmemory;

import com.google.auto.service.AutoService;
import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.e2e.sink.inmemory.InMemoryAggregatedCommitInfo;
import org.apache.seatunnel.e2e.sink.inmemory.InMemoryCommitInfo;
import org.apache.seatunnel.e2e.sink.inmemory.InMemorySink;
import org.apache.seatunnel.e2e.sink.inmemory.InMemoryState;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

@AutoService(value={Factory.class})
public class InMemorySinkFactory
implements TableSinkFactory<SeaTunnelRow, InMemoryState, InMemoryCommitInfo, InMemoryAggregatedCommitInfo> {
    public static final Option<Boolean> THROW_EXCEPTION = Options.key((String)"throw_exception").booleanType().defaultValue((Object)false);
    public static final Option<Boolean> WRITER_SLEEP = Options.key((String)"writer_sleep").booleanType().defaultValue((Object)false);
    public static final Option<Boolean> THROW_OUT_OF_MEMORY = Options.key((String)"throw_out_of_memory").booleanType().defaultValue((Object)false);
    public static final Option<Boolean> CHECKPOINT_SLEEP = Options.key((String)"checkpoint_sleep").booleanType().defaultValue((Object)false);
    public static final Option<Boolean> THROW_EXCEPTION_OF_COMMITTER = Options.key((String)"throw_exception_of_committer").booleanType().defaultValue((Object)false);
    public static final Option<String> ASSERT_OPTIONS_KEY = Options.key((String)"assert_options_key").stringType().noDefaultValue();
    public static final Option<String> ASSERT_OPTIONS_VALUE = Options.key((String)"assert_options_value").stringType().noDefaultValue();
    public static final Option<List<String>> THROW_RUNTIME_EXCEPTION_LIST = Options.key((String)"throw_runtime_exception_list").listType().noDefaultValue();

    public String factoryIdentifier() {
        return "InMemory";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().optional(new Option[]{THROW_EXCEPTION, THROW_OUT_OF_MEMORY, WRITER_SLEEP, CHECKPOINT_SLEEP, THROW_EXCEPTION_OF_COMMITTER, ASSERT_OPTIONS_KEY, ASSERT_OPTIONS_VALUE}).build();
    }

    public TableSink<SeaTunnelRow, InMemoryState, InMemoryCommitInfo, InMemoryAggregatedCommitInfo> createSink(TableSinkFactoryContext context) {
        if (context.getOptions().getOptional(ASSERT_OPTIONS_KEY).isPresent()) {
            String key = (String)context.getOptions().get(ASSERT_OPTIONS_KEY);
            String value = (String)context.getOptions().get(ASSERT_OPTIONS_VALUE);
            Preconditions.checkArgument((boolean)key.equals(value), (Object)String.format("assert key and value not match! key = %s, value = %s", key, value));
        }
        return () -> new InMemorySink(context.getCatalogTable(), context.getOptions());
    }
}

