/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.e2e.sink.inmemory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.sink.MultiTableResourceManager;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.sink.SupportMultiTableSinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.e2e.sink.inmemory.InMemoryCommitInfo;
import org.apache.seatunnel.e2e.sink.inmemory.InMemoryConnection;
import org.apache.seatunnel.e2e.sink.inmemory.InMemoryMultiTableResourceManager;
import org.apache.seatunnel.e2e.sink.inmemory.InMemorySinkFactory;
import org.apache.seatunnel.e2e.sink.inmemory.InMemoryState;

public class InMemorySinkWriter
implements SinkWriter<SeaTunnelRow, InMemoryCommitInfo, InMemoryState>,
SupportMultiTableSinkWriter<InMemoryConnection> {
    private static final List<String> events = new ArrayList<String>();
    private static final List<InMemoryMultiTableResourceManager> resourceManagers = new ArrayList<InMemoryMultiTableResourceManager>();
    private static final Thread THREAD;
    private static int restoreCount;
    private ReadonlyConfig config;
    private InMemoryMultiTableResourceManager resourceManager;

    public static List<String> getEvents() {
        return events;
    }

    public static List<InMemoryMultiTableResourceManager> getResourceManagers() {
        return resourceManagers;
    }

    public InMemorySinkWriter(ReadonlyConfig config) {
        this.config = config;
    }

    public void write(SeaTunnelRow element) throws IOException {
        if (((Boolean)this.config.get(InMemorySinkFactory.WRITER_SLEEP)).booleanValue()) {
            try {
                Thread.sleep(999999999L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (((Boolean)this.config.get(InMemorySinkFactory.THROW_OUT_OF_MEMORY)).booleanValue()) {
            throw new OutOfMemoryError();
        }
        if (this.config.getOptional(InMemorySinkFactory.THROW_RUNTIME_EXCEPTION_LIST).isPresent()) {
            throw new RuntimeException((String)((List)this.config.get(InMemorySinkFactory.THROW_RUNTIME_EXCEPTION_LIST)).get(++restoreCount));
        }
    }

    public Optional<InMemoryCommitInfo> prepareCommit() throws IOException {
        try {
            if (((Boolean)this.config.get(InMemorySinkFactory.THROW_EXCEPTION)).booleanValue()) {
                Thread.sleep(4000L);
                throw new IOException("write failed");
            }
            if (((Boolean)this.config.get(InMemorySinkFactory.CHECKPOINT_SLEEP)).booleanValue()) {
                Thread.sleep(5000L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return Optional.of(new InMemoryCommitInfo());
    }

    public void abortPrepare() {
    }

    public void close() throws IOException {
    }

    public Optional<Integer> primaryKey() {
        return Optional.of(0);
    }

    public MultiTableResourceManager<InMemoryConnection> initMultiTableResourceManager(int tableSize, int queueSize) {
        events.add("initMultiTableResourceManager" + queueSize);
        return new InMemoryMultiTableResourceManager();
    }

    public void setMultiTableResourceManager(MultiTableResourceManager<InMemoryConnection> multiTableResourceManager, int queueIndex) {
        events.add("setMultiTableResourceManager" + queueIndex);
        this.resourceManager = (InMemoryMultiTableResourceManager)multiTableResourceManager;
        resourceManagers.add(this.resourceManager);
    }

    static {
        restoreCount = -1;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        THREAD = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                        System.out.println(classLoader);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }, "InMemorySinkWriter-daemon-thread" + System.currentTimeMillis());
        THREAD.setDaemon(true);
        THREAD.start();
    }
}

