/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.client.job;

import java.util.List;
import lombok.NonNull;
import org.apache.seatunnel.engine.client.SeaTunnelHazelcastClient;
import org.apache.seatunnel.engine.client.job.ClientJobProxy;
import org.apache.seatunnel.engine.client.job.JobMetricsRunner;
import org.apache.seatunnel.engine.client.util.ContentFormatUtil;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.job.JobDAGInfo;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.JobPipelineCheckpointData;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.core.job.JobStatusData;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelCancelJobCodec;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelGetJobCheckpointCodec;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelGetJobDetailStatusCodec;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelGetJobInfoCodec;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelGetJobMetricsCodec;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelGetJobStatusCodec;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelGetRunningJobMetricsCodec;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelListJobStatusCodec;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelSavePointJobCodec;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;

public class JobClient {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final SeaTunnelHazelcastClient hazelcastClient;

    public JobClient(@NonNull SeaTunnelHazelcastClient hazelcastClient) {
        if (hazelcastClient == null) {
            throw new NullPointerException("hazelcastClient is marked non-null but is null");
        }
        this.hazelcastClient = hazelcastClient;
    }

    public long getNewJobId() {
        return this.hazelcastClient.getHazelcastInstance().getFlakeIdGenerator("SeaTunnelIdGenerator").newId();
    }

    public ClientJobProxy createJobProxy(@NonNull JobImmutableInformation jobImmutableInformation) {
        if (jobImmutableInformation == null) {
            throw new NullPointerException("jobImmutableInformation is marked non-null but is null");
        }
        return new ClientJobProxy(this.hazelcastClient, jobImmutableInformation);
    }

    public ClientJobProxy getJobProxy(@NonNull Long jobId) {
        if (jobId == null) {
            throw new NullPointerException("jobId is marked non-null but is null");
        }
        return new ClientJobProxy(this.hazelcastClient, jobId);
    }

    public String getJobDetailStatus(Long jobId) {
        return (String)this.hazelcastClient.requestOnMasterAndDecodeResponse(SeaTunnelGetJobDetailStatusCodec.encodeRequest((long)jobId), SeaTunnelGetJobDetailStatusCodec::decodeResponse);
    }

    public String listJobStatus(boolean format) {
        String jobStatusStr = (String)this.hazelcastClient.requestOnMasterAndDecodeResponse(SeaTunnelListJobStatusCodec.encodeRequest(), SeaTunnelListJobStatusCodec::decodeResponse);
        if (!format) {
            return jobStatusStr;
        }
        try {
            List statusDataList = (List)OBJECT_MAPPER.readValue(jobStatusStr, (TypeReference)new TypeReference<List<JobStatusData>>(){});
            statusDataList.sort((s1, s2) -> {
                if (s1.getSubmitTime() == s2.getSubmitTime()) {
                    return 0;
                }
                return s1.getSubmitTime() > s2.getSubmitTime() ? -1 : 1;
            });
            return ContentFormatUtil.format(statusDataList);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getJobStatus(Long jobId) {
        int jobStatusOrdinal = (Integer)this.hazelcastClient.requestOnMasterAndDecodeResponse(SeaTunnelGetJobStatusCodec.encodeRequest((long)jobId), SeaTunnelGetJobStatusCodec::decodeResponse);
        return JobStatus.values()[jobStatusOrdinal].toString();
    }

    public String getJobMetrics(Long jobId) {
        return (String)this.hazelcastClient.requestOnMasterAndDecodeResponse(SeaTunnelGetJobMetricsCodec.encodeRequest((long)jobId), SeaTunnelGetJobMetricsCodec::decodeResponse);
    }

    public String getRunningJobMetrics() {
        return (String)this.hazelcastClient.requestOnMasterAndDecodeResponse(SeaTunnelGetRunningJobMetricsCodec.encodeRequest(), SeaTunnelGetRunningJobMetricsCodec::decodeResponse);
    }

    public void savePointJob(Long jobId) {
        PassiveCompletableFuture<Void> cancelFuture = this.hazelcastClient.requestOnMasterAndGetCompletableFuture(SeaTunnelSavePointJobCodec.encodeRequest((long)jobId));
        cancelFuture.join();
    }

    public void cancelJob(Long jobId) {
        PassiveCompletableFuture<Void> cancelFuture = this.hazelcastClient.requestOnMasterAndGetCompletableFuture(SeaTunnelCancelJobCodec.encodeRequest((long)jobId));
        cancelFuture.join();
    }

    public JobDAGInfo getJobInfo(Long jobId) {
        return (JobDAGInfo)this.hazelcastClient.getSerializationService().toObject(this.hazelcastClient.requestOnMasterAndDecodeResponse(SeaTunnelGetJobInfoCodec.encodeRequest((long)jobId), SeaTunnelGetJobInfoCodec::decodeResponse));
    }

    public JobMetricsRunner.JobMetricsSummary getJobMetricsSummary(Long jobId) {
        long sourceReadCount = 0L;
        long sinkWriteCount = 0L;
        String jobMetrics = this.getJobMetrics(jobId);
        try {
            JsonNode jsonNode = OBJECT_MAPPER.readTree(jobMetrics);
            JsonNode sourceReaders = jsonNode.get("SourceReceivedCount");
            JsonNode sinkWriters = jsonNode.get("SinkWriteCount");
            for (int i = 0; i < sourceReaders.size(); ++i) {
                JsonNode sourceReader = sourceReaders.get(i);
                JsonNode sinkWriter = sinkWriters.get(i);
                sourceReadCount += sourceReader.get("value").asLong();
                sinkWriteCount += sinkWriter.get("value").asLong();
            }
            return new JobMetricsRunner.JobMetricsSummary(sourceReadCount, sinkWriteCount);
        }
        catch (NullPointerException | JsonProcessingException e) {
            return new JobMetricsRunner.JobMetricsSummary(sourceReadCount, sinkWriteCount);
        }
    }

    public List<JobPipelineCheckpointData> getCheckpointData(Long jobId) {
        return (List)this.hazelcastClient.getSerializationService().toObject(this.hazelcastClient.requestOnMasterAndDecodeResponse(SeaTunnelGetJobCheckpointCodec.encodeRequest((long)jobId), SeaTunnelGetJobCheckpointCodec::decodeResponse));
    }
}

