/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.client.job;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.engine.client.SeaTunnelHazelcastClient;
import org.apache.seatunnel.engine.client.job.ClientJobProxy;
import org.apache.seatunnel.engine.client.job.ConnectorPackageClient;
import org.apache.seatunnel.engine.client.job.JobClient;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.job.AbstractJobEnvironment;
import org.apache.seatunnel.engine.core.job.ConnectorJarIdentifier;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.parse.MultipleTableJobConfigParser;
import org.apache.seatunnel.shade.com.google.common.annotations.VisibleForTesting;

public class ClientJobExecutionEnvironment
extends AbstractJobEnvironment {
    private final String jobFilePath;
    private final List<String> variables;
    private final SeaTunnelHazelcastClient seaTunnelHazelcastClient;
    private final JobClient jobClient;
    private final SeaTunnelConfig seaTunnelConfig;
    private final ConnectorPackageClient connectorPackageClient;

    public ClientJobExecutionEnvironment(JobConfig jobConfig, String jobFilePath, List<String> variables, SeaTunnelHazelcastClient seaTunnelHazelcastClient, SeaTunnelConfig seaTunnelConfig, boolean isStartWithSavePoint, Long jobId) {
        super(jobConfig, isStartWithSavePoint);
        this.jobFilePath = jobFilePath;
        this.variables = variables;
        this.seaTunnelHazelcastClient = seaTunnelHazelcastClient;
        this.jobClient = new JobClient(seaTunnelHazelcastClient);
        this.seaTunnelConfig = seaTunnelConfig;
        Long finalJobId = isStartWithSavePoint || jobId != null ? jobId : Long.valueOf(this.jobClient.getNewJobId());
        this.jobConfig.setJobContext(new JobContext(finalJobId));
        this.connectorPackageClient = new ConnectorPackageClient(seaTunnelHazelcastClient);
    }

    public ClientJobExecutionEnvironment(JobConfig jobConfig, String jobFilePath, List<String> variables, SeaTunnelHazelcastClient seaTunnelHazelcastClient, SeaTunnelConfig seaTunnelConfig, Long jobId) {
        this(jobConfig, jobFilePath, variables, seaTunnelHazelcastClient, seaTunnelConfig, false, jobId);
    }

    protected MultipleTableJobConfigParser getJobConfigParser() {
        List<Object> pipelineCheckpoints = Collections.emptyList();
        if (this.isStartWithSavePoint) {
            LOGGER.info("Start with savepoint, load checkpoint state from job client");
            pipelineCheckpoints = this.jobClient.getCheckpointData(Long.parseLong(this.jobConfig.getJobContext().getJobId()));
        }
        return new MultipleTableJobConfigParser(this.jobFilePath, this.variables, this.idGenerator, this.jobConfig, this.commonPluginJars, this.isStartWithSavePoint, pipelineCheckpoints);
    }

    @VisibleForTesting
    public LogicalDag getLogicalDag() {
        ImmutablePair immutablePair = this.getJobConfigParser().parse(null);
        this.actions.addAll((Collection)immutablePair.getLeft());
        boolean enableUploadConnectorJarPackage = this.seaTunnelConfig.getEngineConfig().getConnectorJarStorageConfig().getEnable();
        if (enableUploadConnectorJarPackage) {
            Set<ConnectorJarIdentifier> commonJarIdentifiers = this.connectorPackageClient.uploadCommonPluginJars(Long.parseLong(this.jobConfig.getJobContext().getJobId()), this.commonPluginJars);
            Set commonPluginJarUrls = ClientJobExecutionEnvironment.getJarUrlsFromIdentifiers(commonJarIdentifiers);
            HashSet<ConnectorJarIdentifier> pluginJarIdentifiers = new HashSet<ConnectorJarIdentifier>();
            this.uploadActionPluginJar(this.actions, pluginJarIdentifiers);
            Set connectorPluginJarUrls = ClientJobExecutionEnvironment.getJarUrlsFromIdentifiers(pluginJarIdentifiers);
            this.connectorJarIdentifiers.addAll(commonJarIdentifiers);
            this.connectorJarIdentifiers.addAll(pluginJarIdentifiers);
            this.jarUrls.addAll(commonPluginJarUrls);
            this.jarUrls.addAll(connectorPluginJarUrls);
            this.actions.forEach(action -> ClientJobExecutionEnvironment.addCommonPluginJarsToAction((Action)action, (Set)commonPluginJarUrls, (Set)commonJarIdentifiers));
        } else {
            this.jarUrls.addAll(this.commonPluginJars);
            this.jarUrls.addAll((Collection)immutablePair.getRight());
            this.actions.forEach(action -> ClientJobExecutionEnvironment.addCommonPluginJarsToAction((Action)action, new HashSet(this.commonPluginJars), Collections.emptySet()));
        }
        return this.getLogicalDagGenerator().generate();
    }

    protected Set<ConnectorJarIdentifier> uploadPluginJars(Set<URL> pluginJarUrls) {
        HashSet<ConnectorJarIdentifier> pluginJarIdentifiers = new HashSet<ConnectorJarIdentifier>();
        pluginJarUrls.forEach(pluginJarUrl -> {
            ConnectorJarIdentifier connectorJarIdentifier = this.connectorPackageClient.uploadConnectorPluginJar(Long.parseLong(this.jobConfig.getJobContext().getJobId()), (URL)pluginJarUrl);
            pluginJarIdentifiers.add(connectorJarIdentifier);
        });
        return pluginJarIdentifiers;
    }

    private void uploadActionPluginJar(List<Action> actions, Set<ConnectorJarIdentifier> result) {
        actions.forEach(action -> {
            Set jarUrls = action.getJarUrls();
            Set<ConnectorJarIdentifier> jarIdentifiers = this.uploadPluginJars(jarUrls);
            result.addAll(jarIdentifiers);
            jarUrls.clear();
            jarUrls.addAll(ClientJobExecutionEnvironment.getJarUrlsFromIdentifiers(jarIdentifiers));
            action.getConnectorJarIdentifiers().addAll(jarIdentifiers);
            if (!action.getUpstream().isEmpty()) {
                this.uploadActionPluginJar(action.getUpstream(), result);
            }
        });
    }

    public ClientJobProxy execute() throws ExecutionException, InterruptedException {
        LogicalDag logicalDag = this.getLogicalDag();
        JobImmutableInformation jobImmutableInformation = new JobImmutableInformation(Long.parseLong(this.jobConfig.getJobContext().getJobId()), this.jobConfig.getName(), this.isStartWithSavePoint, this.seaTunnelHazelcastClient.getSerializationService(), logicalDag, new ArrayList(this.jarUrls), new ArrayList(this.connectorJarIdentifiers));
        return this.jobClient.createJobProxy(jobImmutableInformation);
    }
}

