/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.client.job;

import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.engine.client.job.JobClient;
import org.apache.seatunnel.engine.common.job.JobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobStatusRunner
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(JobStatusRunner.class);
    private final JobClient jobClient;
    private final Long jobId;
    private boolean isEnterPending = false;

    public JobStatusRunner(JobClient jobClient, Long jobId) {
        this.jobClient = jobClient;
        this.jobId = jobId;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("job-status-runner-" + this.jobId);
        try {
            while (this.isPrint(this.jobClient.getJobStatus(this.jobId))) {
                Thread.sleep(5000L);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            log.info("Failed to get job runner status. {}", (Object)ExceptionUtils.getMessage((Throwable)e));
        }
    }

    private boolean isPrint(String jobStatus) {
        boolean isPrint = true;
        switch (JobStatus.fromString((String)jobStatus)) {
            case PENDING: {
                this.isEnterPending = true;
                log.info("Job Id : {} enter pending queue, current status:{} ,please wait task schedule", (Object)this.jobId, (Object)jobStatus);
                break;
            }
            case RUNNING: 
            case SCHEDULED: 
            case FAILING: 
            case FAILED: 
            case DOING_SAVEPOINT: 
            case SAVEPOINT_DONE: 
            case CANCELING: 
            case CANCELED: 
            case FINISHED: 
            case UNKNOWABLE: {
                if (this.isEnterPending) {
                    log.info("Job ID: {} has been scheduled and entered the next state. Current status: {}", (Object)this.jobId, (Object)jobStatus);
                }
                isPrint = false;
            }
        }
        return isPrint;
    }
}

