/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.client.job;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.env.EnvCommonOptions;
import org.apache.seatunnel.common.config.Common;
import org.apache.seatunnel.common.utils.FileUtils;
import org.apache.seatunnel.engine.client.SeaTunnelHazelcastClient;
import org.apache.seatunnel.engine.client.job.ClientJobProxy;
import org.apache.seatunnel.engine.client.job.JobClient;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.common.utils.IdGenerator;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDagGenerator;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.parse.MultipleTableJobConfigParser;

public class JobExecutionEnvironment {
    private static final ILogger LOGGER = Logger.getLogger(JobExecutionEnvironment.class);
    private final boolean isStartWithSavePoint;
    private final JobConfig jobConfig;
    private final List<Action> actions = new ArrayList<Action>();
    private final Set<URL> jarUrls = new HashSet<URL>();
    private final List<URL> commonPluginJars = new ArrayList<URL>();
    private final String jobFilePath;
    private final IdGenerator idGenerator;
    private final SeaTunnelHazelcastClient seaTunnelHazelcastClient;
    private final JobClient jobClient;

    public JobExecutionEnvironment(JobConfig jobConfig, String jobFilePath, SeaTunnelHazelcastClient seaTunnelHazelcastClient, boolean isStartWithSavePoint, Long jobId) {
        this.jobConfig = jobConfig;
        this.jobFilePath = jobFilePath;
        this.idGenerator = new IdGenerator();
        this.seaTunnelHazelcastClient = seaTunnelHazelcastClient;
        this.jobClient = new JobClient(seaTunnelHazelcastClient);
        this.isStartWithSavePoint = isStartWithSavePoint;
        this.jobConfig.setJobContext(new JobContext(Long.valueOf(isStartWithSavePoint ? jobId.longValue() : this.jobClient.getNewJobId())));
        this.commonPluginJars.addAll(this.searchPluginJars());
        this.commonPluginJars.addAll(new ArrayList(Common.getThirdPartyJars((String)jobConfig.getEnvOptions().getOrDefault(EnvCommonOptions.JARS.key(), "").toString()).stream().map(Path::toUri).map(uri -> {
            try {
                return uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new SeaTunnelEngineException("the uri of jar illegal:" + uri, (Throwable)e);
            }
        }).collect(Collectors.toList())));
        LOGGER.info("add common jar in plugins :" + this.commonPluginJars);
    }

    public JobExecutionEnvironment(JobConfig jobConfig, String jobFilePath, SeaTunnelHazelcastClient seaTunnelHazelcastClient) {
        this(jobConfig, jobFilePath, seaTunnelHazelcastClient, false, null);
    }

    private Set<URL> searchPluginJars() {
        try {
            if (Files.exists(Common.pluginRootDir(), new LinkOption[0])) {
                return new HashSet<URL>(FileUtils.searchJarFiles((Path)Common.pluginRootDir()));
            }
        }
        catch (IOException | SeaTunnelEngineException e) {
            LOGGER.warning(String.format("Can't search plugin jars in %s.", Common.pluginRootDir()), e);
        }
        return Collections.emptySet();
    }

    private MultipleTableJobConfigParser getJobConfigParser() {
        return new MultipleTableJobConfigParser(this.jobFilePath, this.idGenerator, this.jobConfig, this.commonPluginJars);
    }

    private LogicalDagGenerator getLogicalDagGenerator() {
        return new LogicalDagGenerator(this.actions, this.jobConfig, this.idGenerator);
    }

    public ClientJobProxy execute() throws ExecutionException, InterruptedException {
        JobImmutableInformation jobImmutableInformation = new JobImmutableInformation(Long.parseLong(this.jobConfig.getJobContext().getJobId()), this.jobConfig.getName(), this.isStartWithSavePoint, this.seaTunnelHazelcastClient.getSerializationService().toData((Object)this.getLogicalDag()), this.jobConfig, new ArrayList<URL>(this.jarUrls));
        return this.jobClient.createJobProxy(jobImmutableInformation);
    }

    private LogicalDag getLogicalDag() {
        ImmutablePair immutablePair = this.getJobConfigParser().parse();
        this.actions.addAll((Collection)immutablePair.getLeft());
        this.jarUrls.addAll((Collection)immutablePair.getRight());
        return this.getLogicalDagGenerator().generate();
    }
}

