/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.config;

import com.hazelcast.internal.util.Preconditions;
import java.util.Collections;
import java.util.Map;
import org.apache.seatunnel.engine.common.config.server.CheckpointConfig;
import org.apache.seatunnel.engine.common.config.server.ConnectorJarStorageConfig;
import org.apache.seatunnel.engine.common.config.server.CoordinatorServiceConfig;
import org.apache.seatunnel.engine.common.config.server.HttpConfig;
import org.apache.seatunnel.engine.common.config.server.QueueType;
import org.apache.seatunnel.engine.common.config.server.ScheduleStrategy;
import org.apache.seatunnel.engine.common.config.server.ServerConfigOptions;
import org.apache.seatunnel.engine.common.config.server.SlotServiceConfig;
import org.apache.seatunnel.engine.common.config.server.TelemetryConfig;
import org.apache.seatunnel.engine.common.config.server.ThreadShareMode;
import org.apache.seatunnel.engine.common.runtime.ExecutionMode;

public class EngineConfig {
    private int backupCount = (Integer)ServerConfigOptions.MasterServerConfigOptions.BACKUP_COUNT.defaultValue();
    private int printExecutionInfoInterval = (Integer)ServerConfigOptions.MasterServerConfigOptions.PRINT_EXECUTION_INFO_INTERVAL.defaultValue();
    private int printJobMetricsInfoInterval = (Integer)ServerConfigOptions.MasterServerConfigOptions.PRINT_JOB_METRICS_INFO_INTERVAL.defaultValue();
    private int jobMetricsBackupInterval = (Integer)ServerConfigOptions.MasterServerConfigOptions.JOB_METRICS_BACKUP_INTERVAL.defaultValue();
    private ThreadShareMode taskExecutionThreadShareMode = (ThreadShareMode)((Object)ServerConfigOptions.WorkerServerConfigOptions.TASK_EXECUTION_THREAD_SHARE_MODE.defaultValue());
    private SlotServiceConfig slotServiceConfig = (SlotServiceConfig)ServerConfigOptions.WorkerServerConfigOptions.SLOT_SERVICE.defaultValue();
    private CheckpointConfig checkpointConfig = (CheckpointConfig)ServerConfigOptions.MasterServerConfigOptions.CHECKPOINT.defaultValue();
    private CoordinatorServiceConfig coordinatorServiceConfig = (CoordinatorServiceConfig)ServerConfigOptions.MasterServerConfigOptions.COORDINATOR_SERVICE.defaultValue();
    private ConnectorJarStorageConfig connectorJarStorageConfig = (ConnectorJarStorageConfig)ServerConfigOptions.MasterServerConfigOptions.CONNECTOR_JAR_STORAGE_CONFIG.defaultValue();
    private boolean classloaderCacheMode = (Boolean)ServerConfigOptions.CLASSLOADER_CACHE_MODE.defaultValue();
    private QueueType queueType = (QueueType)((Object)ServerConfigOptions.WorkerServerConfigOptions.QUEUE_TYPE.defaultValue());
    private int historyJobExpireMinutes = (Integer)ServerConfigOptions.MasterServerConfigOptions.HISTORY_JOB_EXPIRE_MINUTES.defaultValue();
    private ClusterRole clusterRole = ClusterRole.MASTER_AND_WORKER;
    private String eventReportHttpApi;
    private Map<String, String> eventReportHttpHeaders = Collections.emptyMap();
    private ExecutionMode mode = ExecutionMode.CLUSTER;
    private TelemetryConfig telemetryConfig = (TelemetryConfig)ServerConfigOptions.TELEMETRY.defaultValue();
    private ScheduleStrategy scheduleStrategy = (ScheduleStrategy)((Object)ServerConfigOptions.MasterServerConfigOptions.JOB_SCHEDULE_STRATEGY.defaultValue());
    private HttpConfig httpConfig = (HttpConfig)ServerConfigOptions.MasterServerConfigOptions.HTTP.defaultValue();

    public void setBackupCount(int newBackupCount) {
        Preconditions.checkBackupCount((int)newBackupCount, (int)0);
        this.backupCount = newBackupCount;
    }

    public void setScheduleStrategy(ScheduleStrategy scheduleStrategy) {
        this.scheduleStrategy = scheduleStrategy;
    }

    public void setPrintExecutionInfoInterval(int printExecutionInfoInterval) {
        Preconditions.checkPositive((double)printExecutionInfoInterval, (String)(ServerConfigOptions.MasterServerConfigOptions.PRINT_EXECUTION_INFO_INTERVAL + " must be > 0"));
        this.printExecutionInfoInterval = printExecutionInfoInterval;
    }

    public void setPrintJobMetricsInfoInterval(int printJobMetricsInfoInterval) {
        Preconditions.checkPositive((double)printJobMetricsInfoInterval, (String)(ServerConfigOptions.MasterServerConfigOptions.PRINT_JOB_METRICS_INFO_INTERVAL + " must be > 0"));
        this.printJobMetricsInfoInterval = printJobMetricsInfoInterval;
    }

    public void setJobMetricsBackupInterval(int jobMetricsBackupInterval) {
        Preconditions.checkPositive((double)jobMetricsBackupInterval, (String)(ServerConfigOptions.MasterServerConfigOptions.JOB_METRICS_BACKUP_INTERVAL + " must be > 0"));
        this.jobMetricsBackupInterval = jobMetricsBackupInterval;
    }

    public void setTaskExecutionThreadShareMode(ThreadShareMode taskExecutionThreadShareMode) {
        Preconditions.checkNotNull((Object)((Object)this.queueType));
        this.taskExecutionThreadShareMode = taskExecutionThreadShareMode;
    }

    public void setHistoryJobExpireMinutes(int historyJobExpireMinutes) {
        Preconditions.checkPositive((double)historyJobExpireMinutes, (String)(ServerConfigOptions.MasterServerConfigOptions.HISTORY_JOB_EXPIRE_MINUTES + " must be > 0"));
        this.historyJobExpireMinutes = historyJobExpireMinutes;
    }

    public EngineConfig setQueueType(QueueType queueType) {
        Preconditions.checkNotNull((Object)((Object)queueType));
        this.queueType = queueType;
        return this;
    }

    public EngineConfig setEventReportHttpApi(String eventReportHttpApi) {
        this.eventReportHttpApi = eventReportHttpApi;
        return this;
    }

    public EngineConfig setEventReportHttpHeaders(Map<String, String> eventReportHttpHeaders) {
        this.eventReportHttpHeaders = eventReportHttpHeaders;
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public int getPrintExecutionInfoInterval() {
        return this.printExecutionInfoInterval;
    }

    public int getPrintJobMetricsInfoInterval() {
        return this.printJobMetricsInfoInterval;
    }

    public int getJobMetricsBackupInterval() {
        return this.jobMetricsBackupInterval;
    }

    public ThreadShareMode getTaskExecutionThreadShareMode() {
        return this.taskExecutionThreadShareMode;
    }

    public SlotServiceConfig getSlotServiceConfig() {
        return this.slotServiceConfig;
    }

    public CheckpointConfig getCheckpointConfig() {
        return this.checkpointConfig;
    }

    public CoordinatorServiceConfig getCoordinatorServiceConfig() {
        return this.coordinatorServiceConfig;
    }

    public ConnectorJarStorageConfig getConnectorJarStorageConfig() {
        return this.connectorJarStorageConfig;
    }

    public boolean isClassloaderCacheMode() {
        return this.classloaderCacheMode;
    }

    public QueueType getQueueType() {
        return this.queueType;
    }

    public int getHistoryJobExpireMinutes() {
        return this.historyJobExpireMinutes;
    }

    public ClusterRole getClusterRole() {
        return this.clusterRole;
    }

    public String getEventReportHttpApi() {
        return this.eventReportHttpApi;
    }

    public Map<String, String> getEventReportHttpHeaders() {
        return this.eventReportHttpHeaders;
    }

    public ExecutionMode getMode() {
        return this.mode;
    }

    public TelemetryConfig getTelemetryConfig() {
        return this.telemetryConfig;
    }

    public ScheduleStrategy getScheduleStrategy() {
        return this.scheduleStrategy;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public void setSlotServiceConfig(SlotServiceConfig slotServiceConfig) {
        this.slotServiceConfig = slotServiceConfig;
    }

    public void setCheckpointConfig(CheckpointConfig checkpointConfig) {
        this.checkpointConfig = checkpointConfig;
    }

    public void setCoordinatorServiceConfig(CoordinatorServiceConfig coordinatorServiceConfig) {
        this.coordinatorServiceConfig = coordinatorServiceConfig;
    }

    public void setConnectorJarStorageConfig(ConnectorJarStorageConfig connectorJarStorageConfig) {
        this.connectorJarStorageConfig = connectorJarStorageConfig;
    }

    public void setClassloaderCacheMode(boolean classloaderCacheMode) {
        this.classloaderCacheMode = classloaderCacheMode;
    }

    public void setClusterRole(ClusterRole clusterRole) {
        this.clusterRole = clusterRole;
    }

    public void setMode(ExecutionMode mode) {
        this.mode = mode;
    }

    public void setTelemetryConfig(TelemetryConfig telemetryConfig) {
        this.telemetryConfig = telemetryConfig;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EngineConfig)) {
            return false;
        }
        EngineConfig other = (EngineConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBackupCount() != other.getBackupCount()) {
            return false;
        }
        if (this.getPrintExecutionInfoInterval() != other.getPrintExecutionInfoInterval()) {
            return false;
        }
        if (this.getPrintJobMetricsInfoInterval() != other.getPrintJobMetricsInfoInterval()) {
            return false;
        }
        if (this.getJobMetricsBackupInterval() != other.getJobMetricsBackupInterval()) {
            return false;
        }
        if (this.isClassloaderCacheMode() != other.isClassloaderCacheMode()) {
            return false;
        }
        if (this.getHistoryJobExpireMinutes() != other.getHistoryJobExpireMinutes()) {
            return false;
        }
        ThreadShareMode this$taskExecutionThreadShareMode = this.getTaskExecutionThreadShareMode();
        ThreadShareMode other$taskExecutionThreadShareMode = other.getTaskExecutionThreadShareMode();
        if (this$taskExecutionThreadShareMode == null ? other$taskExecutionThreadShareMode != null : !((Object)((Object)this$taskExecutionThreadShareMode)).equals((Object)other$taskExecutionThreadShareMode)) {
            return false;
        }
        SlotServiceConfig this$slotServiceConfig = this.getSlotServiceConfig();
        SlotServiceConfig other$slotServiceConfig = other.getSlotServiceConfig();
        if (this$slotServiceConfig == null ? other$slotServiceConfig != null : !((Object)this$slotServiceConfig).equals(other$slotServiceConfig)) {
            return false;
        }
        CheckpointConfig this$checkpointConfig = this.getCheckpointConfig();
        CheckpointConfig other$checkpointConfig = other.getCheckpointConfig();
        if (this$checkpointConfig == null ? other$checkpointConfig != null : !((Object)this$checkpointConfig).equals(other$checkpointConfig)) {
            return false;
        }
        CoordinatorServiceConfig this$coordinatorServiceConfig = this.getCoordinatorServiceConfig();
        CoordinatorServiceConfig other$coordinatorServiceConfig = other.getCoordinatorServiceConfig();
        if (this$coordinatorServiceConfig == null ? other$coordinatorServiceConfig != null : !((Object)this$coordinatorServiceConfig).equals(other$coordinatorServiceConfig)) {
            return false;
        }
        ConnectorJarStorageConfig this$connectorJarStorageConfig = this.getConnectorJarStorageConfig();
        ConnectorJarStorageConfig other$connectorJarStorageConfig = other.getConnectorJarStorageConfig();
        if (this$connectorJarStorageConfig == null ? other$connectorJarStorageConfig != null : !((Object)this$connectorJarStorageConfig).equals(other$connectorJarStorageConfig)) {
            return false;
        }
        QueueType this$queueType = this.getQueueType();
        QueueType other$queueType = other.getQueueType();
        if (this$queueType == null ? other$queueType != null : !((Object)((Object)this$queueType)).equals((Object)other$queueType)) {
            return false;
        }
        ClusterRole this$clusterRole = this.getClusterRole();
        ClusterRole other$clusterRole = other.getClusterRole();
        if (this$clusterRole == null ? other$clusterRole != null : !((Object)((Object)this$clusterRole)).equals((Object)other$clusterRole)) {
            return false;
        }
        String this$eventReportHttpApi = this.getEventReportHttpApi();
        String other$eventReportHttpApi = other.getEventReportHttpApi();
        if (this$eventReportHttpApi == null ? other$eventReportHttpApi != null : !this$eventReportHttpApi.equals(other$eventReportHttpApi)) {
            return false;
        }
        Map<String, String> this$eventReportHttpHeaders = this.getEventReportHttpHeaders();
        Map<String, String> other$eventReportHttpHeaders = other.getEventReportHttpHeaders();
        if (this$eventReportHttpHeaders == null ? other$eventReportHttpHeaders != null : !((Object)this$eventReportHttpHeaders).equals(other$eventReportHttpHeaders)) {
            return false;
        }
        ExecutionMode this$mode = this.getMode();
        ExecutionMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        TelemetryConfig this$telemetryConfig = this.getTelemetryConfig();
        TelemetryConfig other$telemetryConfig = other.getTelemetryConfig();
        if (this$telemetryConfig == null ? other$telemetryConfig != null : !((Object)this$telemetryConfig).equals(other$telemetryConfig)) {
            return false;
        }
        ScheduleStrategy this$scheduleStrategy = this.getScheduleStrategy();
        ScheduleStrategy other$scheduleStrategy = other.getScheduleStrategy();
        if (this$scheduleStrategy == null ? other$scheduleStrategy != null : !((Object)((Object)this$scheduleStrategy)).equals((Object)other$scheduleStrategy)) {
            return false;
        }
        HttpConfig this$httpConfig = this.getHttpConfig();
        HttpConfig other$httpConfig = other.getHttpConfig();
        return !(this$httpConfig == null ? other$httpConfig != null : !((Object)this$httpConfig).equals(other$httpConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EngineConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBackupCount();
        result = result * 59 + this.getPrintExecutionInfoInterval();
        result = result * 59 + this.getPrintJobMetricsInfoInterval();
        result = result * 59 + this.getJobMetricsBackupInterval();
        result = result * 59 + (this.isClassloaderCacheMode() ? 79 : 97);
        result = result * 59 + this.getHistoryJobExpireMinutes();
        ThreadShareMode $taskExecutionThreadShareMode = this.getTaskExecutionThreadShareMode();
        result = result * 59 + ($taskExecutionThreadShareMode == null ? 43 : ((Object)((Object)$taskExecutionThreadShareMode)).hashCode());
        SlotServiceConfig $slotServiceConfig = this.getSlotServiceConfig();
        result = result * 59 + ($slotServiceConfig == null ? 43 : ((Object)$slotServiceConfig).hashCode());
        CheckpointConfig $checkpointConfig = this.getCheckpointConfig();
        result = result * 59 + ($checkpointConfig == null ? 43 : ((Object)$checkpointConfig).hashCode());
        CoordinatorServiceConfig $coordinatorServiceConfig = this.getCoordinatorServiceConfig();
        result = result * 59 + ($coordinatorServiceConfig == null ? 43 : ((Object)$coordinatorServiceConfig).hashCode());
        ConnectorJarStorageConfig $connectorJarStorageConfig = this.getConnectorJarStorageConfig();
        result = result * 59 + ($connectorJarStorageConfig == null ? 43 : ((Object)$connectorJarStorageConfig).hashCode());
        QueueType $queueType = this.getQueueType();
        result = result * 59 + ($queueType == null ? 43 : ((Object)((Object)$queueType)).hashCode());
        ClusterRole $clusterRole = this.getClusterRole();
        result = result * 59 + ($clusterRole == null ? 43 : ((Object)((Object)$clusterRole)).hashCode());
        String $eventReportHttpApi = this.getEventReportHttpApi();
        result = result * 59 + ($eventReportHttpApi == null ? 43 : $eventReportHttpApi.hashCode());
        Map<String, String> $eventReportHttpHeaders = this.getEventReportHttpHeaders();
        result = result * 59 + ($eventReportHttpHeaders == null ? 43 : ((Object)$eventReportHttpHeaders).hashCode());
        ExecutionMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        TelemetryConfig $telemetryConfig = this.getTelemetryConfig();
        result = result * 59 + ($telemetryConfig == null ? 43 : ((Object)$telemetryConfig).hashCode());
        ScheduleStrategy $scheduleStrategy = this.getScheduleStrategy();
        result = result * 59 + ($scheduleStrategy == null ? 43 : ((Object)((Object)$scheduleStrategy)).hashCode());
        HttpConfig $httpConfig = this.getHttpConfig();
        result = result * 59 + ($httpConfig == null ? 43 : ((Object)$httpConfig).hashCode());
        return result;
    }

    public String toString() {
        return "EngineConfig(backupCount=" + this.getBackupCount() + ", printExecutionInfoInterval=" + this.getPrintExecutionInfoInterval() + ", printJobMetricsInfoInterval=" + this.getPrintJobMetricsInfoInterval() + ", jobMetricsBackupInterval=" + this.getJobMetricsBackupInterval() + ", taskExecutionThreadShareMode=" + (Object)((Object)this.getTaskExecutionThreadShareMode()) + ", slotServiceConfig=" + this.getSlotServiceConfig() + ", checkpointConfig=" + this.getCheckpointConfig() + ", coordinatorServiceConfig=" + this.getCoordinatorServiceConfig() + ", connectorJarStorageConfig=" + this.getConnectorJarStorageConfig() + ", classloaderCacheMode=" + this.isClassloaderCacheMode() + ", queueType=" + (Object)((Object)this.getQueueType()) + ", historyJobExpireMinutes=" + this.getHistoryJobExpireMinutes() + ", clusterRole=" + (Object)((Object)this.getClusterRole()) + ", eventReportHttpApi=" + this.getEventReportHttpApi() + ", eventReportHttpHeaders=" + this.getEventReportHttpHeaders() + ", mode=" + (Object)((Object)this.getMode()) + ", telemetryConfig=" + this.getTelemetryConfig() + ", scheduleStrategy=" + (Object)((Object)this.getScheduleStrategy()) + ", httpConfig=" + this.getHttpConfig() + ")";
    }

    public static enum ClusterRole {
        MASTER_AND_WORKER,
        MASTER,
        WORKER;

    }
}

