/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.config.server;

import com.hazelcast.internal.util.Preconditions;
import java.io.Serializable;
import org.apache.seatunnel.engine.common.config.server.ServerConfigOptions;

public class CoordinatorServiceConfig
implements Serializable {
    private int coreThreadNum = (Integer)ServerConfigOptions.MasterServerConfigOptions.CORE_THREAD_NUM.defaultValue();
    private int maxThreadNum = (Integer)ServerConfigOptions.MasterServerConfigOptions.MAX_THREAD_NUM.defaultValue();

    public void setCoreThreadNum(int coreThreadNum) {
        Preconditions.checkPositive((double)coreThreadNum, (String)(ServerConfigOptions.MasterServerConfigOptions.CORE_THREAD_NUM + " must be >= 0"));
        this.coreThreadNum = coreThreadNum;
    }

    public void setMaxThreadNum(int maxThreadNum) {
        Preconditions.checkPositive((double)maxThreadNum, (String)(ServerConfigOptions.MasterServerConfigOptions.MAX_THREAD_NUM + " must be > 0"));
        this.maxThreadNum = maxThreadNum;
    }

    public int getCoreThreadNum() {
        return this.coreThreadNum;
    }

    public int getMaxThreadNum() {
        return this.maxThreadNum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoordinatorServiceConfig)) {
            return false;
        }
        CoordinatorServiceConfig other = (CoordinatorServiceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCoreThreadNum() != other.getCoreThreadNum()) {
            return false;
        }
        return this.getMaxThreadNum() == other.getMaxThreadNum();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CoordinatorServiceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCoreThreadNum();
        result = result * 59 + this.getMaxThreadNum();
        return result;
    }

    public String toString() {
        return "CoordinatorServiceConfig(coreThreadNum=" + this.getCoreThreadNum() + ", maxThreadNum=" + this.getMaxThreadNum() + ")";
    }
}

